/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public final class FreezeCommand {
    private FreezeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"freeze").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FREEZE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(FreezeCommand::toggle)));
    }

    private static int toggle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        boolean frozen = storage.isFrozen(target.getUUID());
        storage.setFrozen(target.getUUID(), !frozen);
        if (frozen) {
            FreezeCommand.clearEffect(target, "minecraft:slowness");
            FreezeCommand.clearEffect(target, "minecraft:mining_fatigue");
            FreezeCommand.clearEffect(target, "minecraft:jump_boost");
            FreezeCommand.clearEffect(target, "minecraft:weakness");
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.freeze.unfrozen"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.freeze.removed", target.getName()), true);
        } else {
            FreezeCommand.applyEffect(target, "minecraft:slowness", 10);
            FreezeCommand.applyEffect(target, "minecraft:mining_fatigue", 10);
            FreezeCommand.applyEffect(target, "minecraft:jump_boost", 200);
            FreezeCommand.applyEffect(target, "minecraft:weakness", 2);
            target.stopRiding();
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.freeze.frozen"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.freeze.applied", target.getName()), true);
        }
        return 1;
    }

    private static void applyEffect(ServerPlayer player, String id, int amplifier) {
        Holder<MobEffect> effect = FreezeCommand.effect(id);
        if (effect != null) {
            player.addEffect(new MobEffectInstance(effect, Integer.MAX_VALUE, amplifier, false, false, true));
        }
    }

    private static void clearEffect(ServerPlayer player, String id) {
        Holder<MobEffect> effect = FreezeCommand.effect(id);
        if (effect != null) {
            player.removeEffect(effect);
        }
    }

    private static Holder<MobEffect> effect(String id) {
        ResourceLocation location = ResourceLocation.tryParse((String)id);
        if (location == null) {
            return null;
        }
        return BuiltInRegistries.MOB_EFFECT.getOptional(location).map(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).wrapAsHolder(arg_0)).orElse(null);
    }
}

