/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public final class GamemodeCommand {
    private static final SuggestionProvider<CommandSourceStack> MODES = (context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"survival", "creative", "adventure", "spectator"}, (SuggestionsBuilder)builder);
    private static final SimpleCommandExceptionType INVALID_MODE = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.gm.invalid"));

    private GamemodeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gm").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_GAMEMODE))).then(((RequiredArgumentBuilder)Commands.argument((String)"mode", (ArgumentType)StringArgumentType.string()).suggests(MODES).executes(context -> GamemodeCommand.apply((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_GAMEMODE_OTHERS))).executes(context -> GamemodeCommand.apply((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"))))));
    }

    private static int apply(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        GameType mode;
        String name;
        switch (name = StringArgumentType.getString(context, (String)"mode").toLowerCase(Locale.ROOT)) {
            case "0": 
            case "s": 
            case "survival": {
                GameType gameType = GameType.SURVIVAL;
                break;
            }
            case "1": 
            case "c": 
            case "creative": {
                GameType gameType = GameType.CREATIVE;
                break;
            }
            case "2": 
            case "a": 
            case "adventure": {
                GameType gameType = GameType.ADVENTURE;
                break;
            }
            case "3": 
            case "sp": 
            case "spectator": {
                GameType gameType = GameType.SPECTATOR;
                break;
            }
            default: {
                GameType gameType = mode = null;
            }
        }
        if (mode == null) {
            throw INVALID_MODE.create();
        }
        target.setGameMode(mode);
        MutableComponent display = Component.literal((String)mode.getName());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> GamemodeCommand.lambda$apply$5(target, (Component)display), true);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.gm.notice", display));
        return 1;
    }

    private static /* synthetic */ Component lambda$apply$5(ServerPlayer target, Component display) {
        return Localization.formatted("commands.foundryx.gm.changed", target.getName(), display);
    }
}

