/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;

public final class GcCommand {
    private GcCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gc").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_GC))).executes(context -> GcCommand.display((CommandSourceStack)context.getSource(), false))).then(Commands.literal((String)"run").executes(context -> GcCommand.display((CommandSourceStack)context.getSource(), true))));
    }

    private static int display(CommandSourceStack source, boolean runGc) {
        double mspt;
        String notAvailable;
        MinecraftServer server = source.getServer();
        if (server == null) {
            return 0;
        }
        if (runGc) {
            System.gc();
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.ran"), false);
        }
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        java.lang.management.OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        String uptime = GcCommand.formatDuration(runtimeMXBean.getUptime());
        String processCpu = notAvailable = Localization.formatted("commands.foundryx.gc.not_available").getString();
        String systemCpu = notAvailable;
        int cpuCores = operatingSystemBean.getAvailableProcessors();
        if (operatingSystemBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunBean = (OperatingSystemMXBean)operatingSystemBean;
            double processLoad = sunBean.getProcessCpuLoad();
            double systemLoad = sunBean.getSystemCpuLoad();
            if (processLoad >= 0.0) {
                processCpu = GcCommand.formatPercent(processLoad * 100.0);
            }
            if (systemLoad >= 0.0) {
                systemCpu = GcCommand.formatPercent(systemLoad * 100.0);
            }
        }
        String msptDisplay = (mspt = GcCommand.getAverageMspt(server)) > 0.0 ? GcCommand.formatDouble(mspt) : notAvailable;
        String tpsDisplay = mspt > 0.0 ? GcCommand.formatDouble(Math.min(1000.0 / mspt, 20.0)) : notAvailable;
        int playerCount = server.getPlayerList().getPlayerCount();
        int maxPlayers = server.getPlayerList().getMaxPlayers();
        int threadCount = threadMXBean != null ? threadMXBean.getThreadCount() : Thread.activeCount();
        String processCpuDisplay = processCpu;
        String systemCpuDisplay = systemCpu;
        String msptText = msptDisplay;
        String tpsText = tpsDisplay;
        String uptimeText = uptime;
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.header"), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.memory", GcCommand.formatBytes(used), GcCommand.formatBytes(free), GcCommand.formatBytes(total), GcCommand.formatBytes(max)), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.tps", tpsText, msptText), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.cpu", processCpuDisplay, systemCpuDisplay, cpuCores), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.players", playerCount, maxPlayers), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.threads", threadCount), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.uptime", uptimeText), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.gc.footer"), false);
        return 1;
    }

    private static String formatBytes(long bytes) {
        int unitIndex;
        if (bytes <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        double value = bytes;
        for (unitIndex = 0; value >= 1024.0 && unitIndex < units.length - 1; value /= 1024.0, ++unitIndex) {
        }
        if (unitIndex == 0) {
            return (long)value + " " + units[unitIndex];
        }
        return GcCommand.formatDouble(value) + " " + units[unitIndex];
    }

    private static String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long days = seconds / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        builder.append(String.format(Locale.ROOT, "%02d:%02d:%02d", hours, minutes, seconds));
        return builder.toString().trim();
    }

    private static String formatPercent(double value) {
        return String.format(Locale.ROOT, "%.2f%%", value);
    }

    private static String formatDouble(double value) {
        return String.format(Locale.ROOT, "%.2f", value);
    }

    private static double getAverageMspt(MinecraftServer server) {
        Double result = GcCommand.invokeAverageMethod(server, "getAverageTickTimeNanos", 1000000.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageMethod(server, "getAverageTickTime", 1.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageMethod(server, "m_129903_", 1.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageMethod(server, "m_18321_", 1.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageMethod(server, "aW", 1000000.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageArrayMethod(server, "getTickTimes", 1000000.0);
        if (result != null) {
            return result;
        }
        result = GcCommand.invokeAverageArrayMethod(server, "aX", 1000000.0);
        if (result != null) {
            return result;
        }
        Double fieldValue = GcCommand.readAverageField(server, "currentAverageTickTime");
        if (fieldValue != null) {
            return fieldValue;
        }
        fieldValue = GcCommand.readAverageField(server, "f_185294_");
        if (fieldValue != null) {
            return fieldValue;
        }
        fieldValue = GcCommand.readAverageField(server, "l");
        if (fieldValue != null) {
            return fieldValue;
        }
        fieldValue = GcCommand.readAverageArrayField(server, "tickTimes", 1000000.0);
        if (fieldValue != null) {
            return fieldValue;
        }
        fieldValue = GcCommand.readAverageArrayField(server, "f_139588_", 1000000.0);
        if (fieldValue != null) {
            return fieldValue;
        }
        fieldValue = GcCommand.readAverageArrayField(server, "Z", 1000000.0);
        if (fieldValue != null) {
            return fieldValue;
        }
        return -1.0;
    }

    private static Double invokeAverageMethod(MinecraftServer server, String name, double divisor) {
        try {
            Method method = server.getClass().getMethod(name, new Class[0]);
            Object value = method.invoke((Object)server, new Object[0]);
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.doubleValue() / divisor;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Double invokeAverageArrayMethod(MinecraftServer server, String name, double divisor) {
        try {
            long[] data;
            Method method = server.getClass().getMethod(name, new Class[0]);
            Object value = method.invoke((Object)server, new Object[0]);
            if (value instanceof long[] && (data = (long[])value).length > 0) {
                long sum = 0L;
                for (long tickTime : data) {
                    sum += tickTime;
                }
                return (double)sum / (double)data.length / divisor;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Double readAverageField(MinecraftServer server, String name) {
        return GcCommand.readAverageField(server, name, 1.0);
    }

    private static Double readAverageField(MinecraftServer server, String name, double divisor) {
        try {
            Field field = server.getClass().getDeclaredField(name);
            field.setAccessible(true);
            Object value = field.get(server);
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.doubleValue() / divisor;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Double readAverageArrayField(MinecraftServer server, String name, double divisor) {
        try {
            long[] data;
            Field field = server.getClass().getDeclaredField(name);
            field.setAccessible(true);
            Object value = field.get(server);
            if (value instanceof long[] && (data = (long[])value).length > 0) {
                long sum = 0L;
                for (long tickTime : data) {
                    sum += tickTime;
                }
                return (double)sum / (double)data.length / divisor;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

