/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class GodCommand {
    private GodCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"god").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_GOD))).executes(context -> GodCommand.toggleSelf((CommandContext<CommandSourceStack>)context))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_GOD_OTHERS))).executes(GodCommand::toggleOther)));
    }

    private static int toggleSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return GodCommand.toggle(context, player);
    }

    private static int toggleOther(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        return GodCommand.toggle(context, target);
    }

    private static int toggle(CommandContext<CommandSourceStack> context, ServerPlayer target) {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        boolean enabled = !storage.hasGodMode(target.getUUID());
        storage.setGodMode(target.getUUID(), enabled);
        target.setInvulnerable(enabled);
        target.getAbilities().invulnerable = enabled;
        target.onUpdateAbilities();
        if (enabled) {
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.god.enabled"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.god.applied", target.getName()), true);
        } else {
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.god.disabled"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.god.removed", target.getName()), true);
        }
        return 1;
    }
}

