/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class InvseeCommand {
    private InvseeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"invsee").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_INVSEE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(InvseeCommand::inspect)));
    }

    private static int inspect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer viewer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        viewer.openMenu((MenuProvider)new SimpleMenuProvider((id, viewerInventory, player) -> new InvseeMenu(id, viewerInventory, target), (Component)Localization.formatted("commands.foundryx.invsee.title", target.getDisplayName())));
        viewer.sendSystemMessage((Component)Localization.formatted("commands.foundryx.invsee.opened", target.getDisplayName()));
        return 1;
    }

    private static class InvseeMenu
    extends ChestMenu {
        private final TargetInventoryContainer targetContainer;

        protected InvseeMenu(int containerId, Inventory viewerInventory, ServerPlayer target) {
            this(containerId, viewerInventory, new TargetInventoryContainer(target));
        }

        private InvseeMenu(int containerId, Inventory viewerInventory, TargetInventoryContainer container) {
            super(MenuType.GENERIC_9x5, containerId, viewerInventory, (Container)container, 5);
            this.targetContainer = container;
        }

        public void removed(Player player) {
            super.removed(player);
            this.targetContainer.onMenuClosed();
        }
    }

    private static class TargetInventoryContainer
    implements Container {
        private static final int CONTAINER_SIZE = 45;
        private final Inventory targetInventory;
        private final ServerPlayer targetPlayer;
        private final NonNullList<ItemStack> paddingSlots;

        TargetInventoryContainer(ServerPlayer targetPlayer) {
            this.targetPlayer = targetPlayer;
            this.targetInventory = targetPlayer.getInventory();
            this.paddingSlots = NonNullList.withSize((int)Math.max(0, 45 - this.targetInventory.getContainerSize()), (Object)ItemStack.EMPTY);
        }

        private boolean isTargetIndex(int index) {
            return index >= 0 && index < this.targetInventory.getContainerSize();
        }

        private int paddingIndex(int index) {
            return index - this.targetInventory.getContainerSize();
        }

        public int getContainerSize() {
            return 45;
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.targetInventory.getContainerSize(); ++i) {
                if (this.targetInventory.getItem(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int index) {
            if (this.isTargetIndex(index)) {
                return this.targetInventory.getItem(index);
            }
            int padding = this.paddingIndex(index);
            return padding >= 0 && padding < this.paddingSlots.size() ? (ItemStack)this.paddingSlots.get(padding) : ItemStack.EMPTY;
        }

        public ItemStack removeItem(int index, int count) {
            if (this.isTargetIndex(index)) {
                ItemStack previous = this.targetInventory.getItem(index).copy();
                ItemStack stack = this.targetInventory.removeItem(index, count);
                this.handleEquipmentChange(index, previous);
                this.targetInventory.setChanged();
                this.targetPlayer.inventoryMenu.broadcastChanges();
                this.targetPlayer.containerMenu.broadcastChanges();
                return stack;
            }
            return ItemStack.EMPTY;
        }

        public ItemStack removeItemNoUpdate(int index) {
            if (this.isTargetIndex(index)) {
                ItemStack previous = this.targetInventory.getItem(index).copy();
                ItemStack stack = this.targetInventory.removeItemNoUpdate(index);
                this.handleEquipmentChange(index, previous);
                this.targetInventory.setChanged();
                this.targetPlayer.inventoryMenu.broadcastChanges();
                this.targetPlayer.containerMenu.broadcastChanges();
                return stack;
            }
            return ItemStack.EMPTY;
        }

        public void setItem(int index, ItemStack stack) {
            if (this.isTargetIndex(index)) {
                ItemStack previous = this.targetInventory.getItem(index).copy();
                this.targetInventory.setItem(index, stack);
                this.handleEquipmentChange(index, previous);
                this.targetInventory.setChanged();
                this.targetPlayer.inventoryMenu.broadcastChanges();
                this.targetPlayer.containerMenu.broadcastChanges();
            }
        }

        public void setChanged() {
            this.targetInventory.setChanged();
            this.targetPlayer.inventoryMenu.broadcastChanges();
            this.targetPlayer.containerMenu.broadcastChanges();
        }

        public boolean stillValid(Player player) {
            return this.targetPlayer.isAlive();
        }

        public void startOpen(Player player) {
            this.targetInventory.startOpen((ContainerUser)player);
        }

        public void stopOpen(Player player) {
            this.targetInventory.stopOpen((ContainerUser)player);
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            return this.isTargetIndex(index) && this.targetInventory.canPlaceItem(index, stack);
        }

        public int countItem(Item item) {
            return this.targetInventory.countItem(item);
        }

        public void clearContent() {
            for (int i = 0; i < this.targetInventory.getContainerSize(); ++i) {
                ItemStack previous = this.targetInventory.getItem(i).copy();
                this.targetInventory.setItem(i, ItemStack.EMPTY);
                this.handleEquipmentChange(i, previous);
            }
            this.targetInventory.setChanged();
            this.targetPlayer.inventoryMenu.broadcastChanges();
            this.targetPlayer.containerMenu.broadcastChanges();
        }

        void onMenuClosed() {
            this.targetInventory.setChanged();
            this.targetPlayer.inventoryMenu.broadcastChanges();
            this.targetPlayer.containerMenu.broadcastChanges();
        }

        private void handleEquipmentChange(int index, ItemStack previous) {
            EquipmentSlot slot = this.mapToEquipmentSlot(index);
            if (slot == null) {
                return;
            }
            ItemStack current = this.targetInventory.getItem(index);
            if (ItemStack.isSameItemSameComponents((ItemStack)previous, (ItemStack)current) && previous.getCount() == current.getCount()) {
                return;
            }
            this.targetPlayer.onEquipItem(slot, previous, current);
        }

        private EquipmentSlot mapToEquipmentSlot(int index) {
            return switch (index) {
                case 36 -> EquipmentSlot.FEET;
                case 37 -> EquipmentSlot.LEGS;
                case 38 -> EquipmentSlot.CHEST;
                case 39 -> EquipmentSlot.HEAD;
                case 40 -> EquipmentSlot.OFFHAND;
                default -> null;
            };
        }
    }
}

