/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.admin.JailRestrictions;
import com.foundryx.command.admin.JailScheduler;
import com.foundryx.command.util.DurationParser;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;

public final class JailCommands {
    private static final SimpleCommandExceptionType REQUIRES_PLAYER = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.jail.player_required"));
    private static final DynamicCommandExceptionType INVALID_DURATION = new DynamicCommandExceptionType(input -> Localization.formatted("commands.foundryx.jail.invalid_duration", input));
    private static final Map<UUID, PendingSelection> PENDING_SELECTIONS = new HashMap<UUID, PendingSelection>();

    private JailCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setjail").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_SET_JAIL))).then(Commands.literal((String)"pos1").executes(JailCommands::setJailPos1))).then(Commands.literal((String)"pos2").executes(JailCommands::setJailPos2))).then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(JailCommands::setJail))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"deljail").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_SET_JAIL))).executes(JailCommands::deleteJail));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jail").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_JAIL))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> JailCommands.jail((CommandContext<CommandSourceStack>)context, null))).then(Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).executes(context -> JailCommands.jail((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"duration"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unjail").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_UNJAIL))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(JailCommands::unjail)));
    }

    private static int setJail(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer jailer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (jailer == null) {
            throw REQUIRES_PLAYER.create();
        }
        ServerLevel level = jailer.level();
        BlockPos first = BlockPosArgument.getLoadedBlockPos(context, (String)"corner1");
        BlockPos second = BlockPosArgument.getLoadedBlockPos(context, (String)"corner2");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        storage.setJailRegion((ResourceKey<Level>)level.dimension(), first, second, jailer.getYRot(), jailer.getXRot());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.setjail.saved"), true);
        return 1;
    }

    private static int setJailPos1(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer jailer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (jailer == null) {
            throw REQUIRES_PLAYER.create();
        }
        BlockPos position = jailer.blockPosition();
        PENDING_SELECTIONS.put(jailer.getUUID(), new PendingSelection((ResourceKey<Level>)jailer.level().dimension(), position));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.setjail.pos1", position.getX(), position.getY(), position.getZ()), false);
        return 1;
    }

    private static int setJailPos2(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer jailer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (jailer == null) {
            throw REQUIRES_PLAYER.create();
        }
        PendingSelection selection = PENDING_SELECTIONS.get(jailer.getUUID());
        if (selection == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.setjail.pos1_required"));
            return 0;
        }
        if (!selection.dimension().equals((Object)jailer.level().dimension())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.setjail.dimension_mismatch"));
            return 0;
        }
        BlockPos current = jailer.blockPosition();
        BlockPos first = selection.firstCorner();
        BlockPos min = new BlockPos(Math.min(first.getX(), current.getX()), Math.min(first.getY(), current.getY()), Math.min(first.getZ(), current.getZ()));
        BlockPos max = new BlockPos(Math.max(first.getX(), current.getX()), Math.max(first.getY(), current.getY()), Math.max(first.getZ(), current.getZ()));
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        storage.setJailRegion(selection.dimension(), min, max, jailer.getYRot(), jailer.getXRot());
        PENDING_SELECTIONS.remove(jailer.getUUID());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.setjail.pos2", current.getX(), current.getY(), current.getZ()), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.setjail.saved"), true);
        return 1;
    }

    private static int deleteJail(CommandContext<CommandSourceStack> context) {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.deleteJailRegion()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.deljail.removed"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.deljail.missing"));
        return 0;
    }

    private static int jail(CommandContext<CommandSourceStack> context, String durationInput) throws CommandSyntaxException {
        ServerPlayer jailer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (jailer == null) {
            throw REQUIRES_PLAYER.create();
        }
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.isJailed(target.getUUID())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.jail.already", target.getName()));
            return 0;
        }
        Optional<FoundryxDataStorage.JailRegion> region = storage.getJailRegion();
        if (region.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.jail.region_missing"));
            return 0;
        }
        FoundryxDataStorage.LocationSnapshot original = FoundryxDataStorage.LocationSnapshot.from(target);
        FoundryxDataStorage.LocationSnapshot jailLocation = region.get().toSnapshot();
        Long releaseAt = null;
        Long durationSeconds = null;
        if (durationInput != null) {
            durationSeconds = DurationParser.parse(durationInput, INVALID_DURATION);
            try {
                long durationMillis = Math.multiplyExact((long)durationSeconds, 1000L);
                releaseAt = Math.addExact(System.currentTimeMillis(), durationMillis);
            }
            catch (ArithmeticException exception) {
                throw INVALID_DURATION.create((Object)durationInput);
            }
        }
        storage.jailPlayer(target.getUUID(), original, jailLocation, releaseAt);
        Optional<FoundryxDataStorage.TeleportTarget> destination = jailLocation.toTeleportTarget();
        if (destination.isEmpty() || !TeleportService.teleport(target, destination.get(), storage)) {
            storage.unjailPlayer(target.getUUID());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
            return 0;
        }
        JailCommands.applyJailEffects(target);
        if (releaseAt != null) {
            JailScheduler.scheduleRelease(((CommandSourceStack)context.getSource()).getServer(), target.getUUID(), releaseAt);
            long seconds = durationSeconds == null ? 0L : durationSeconds;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.jail.success.timed", target.getName(), seconds), true);
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.jail.timed.notice", seconds));
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.jail.success", target.getName()), true);
        }
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.jail.notice", jailer.getName()));
        return 1;
    }

    private static int unjail(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        JailScheduler.cancelRelease(target.getUUID());
        Optional<FoundryxDataStorage.JailRecord> record = storage.unjailPlayer(target.getUUID());
        if (record.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.unjail.not_jailed", target.getName()));
            return 0;
        }
        JailCommands.release(target, record.get(), storage);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.unjail.success", target.getName()), true);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.unjail.notice"));
        return 1;
    }

    static void release(ServerPlayer target, FoundryxDataStorage.JailRecord record, FoundryxDataStorage storage) {
        JailCommands.removeJailEffects(target);
        JailRestrictions.clearNotice(target);
        Optional release = Optional.ofNullable(record.originalLocation()).flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
        release.ifPresent(targetPoint -> TeleportService.teleport(target, targetPoint, storage));
    }

    static void applyJailEffects(ServerPlayer target) {
        JailCommands.clearEffect(target, "minecraft:slowness");
        JailCommands.clearEffect(target, "minecraft:mining_fatigue");
        JailCommands.clearEffect(target, "minecraft:weakness");
        JailCommands.clearEffect(target, "minecraft:jump_boost");
        JailCommands.applyEffect(target, "minecraft:slowness", 10);
        JailCommands.applyEffect(target, "minecraft:mining_fatigue", 10);
        JailCommands.applyEffect(target, "minecraft:weakness", 2);
        JailCommands.applyEffect(target, "minecraft:jump_boost", 200);
        target.stopRiding();
    }

    static void removeJailEffects(ServerPlayer target) {
        JailCommands.clearEffect(target, "minecraft:slowness");
        JailCommands.clearEffect(target, "minecraft:mining_fatigue");
        JailCommands.clearEffect(target, "minecraft:weakness");
        JailCommands.clearEffect(target, "minecraft:jump_boost");
    }

    private static void applyEffect(ServerPlayer player, String id, int amplifier) {
        Holder<MobEffect> effect = JailCommands.effect(id);
        if (effect != null) {
            player.addEffect(new MobEffectInstance(effect, Integer.MAX_VALUE, amplifier, false, false, true));
        }
    }

    private static void clearEffect(ServerPlayer player, String id) {
        Holder<MobEffect> effect = JailCommands.effect(id);
        if (effect != null) {
            player.removeEffect(effect);
        }
    }

    private static Holder<MobEffect> effect(String id) {
        ResourceLocation location = ResourceLocation.tryParse((String)id);
        if (location == null) {
            return null;
        }
        return BuiltInRegistries.MOB_EFFECT.getOptional(location).map(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).wrapAsHolder(arg_0)).orElse(null);
    }

    private record PendingSelection(ResourceKey<Level> dimension, BlockPos firstCorner) {
    }
}

