/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.admin.JailCommands;
import com.foundryx.command.admin.JailScheduler;
import com.foundryx.localization.Localization;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportService;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public final class JailHooks {
    private JailHooks() {
    }

    public static void handlePlayerJoin(ServerPlayer player) {
        ServerLevel serverLevel = player.level();
        if (!(serverLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = serverLevel;
        MinecraftServer server = level.getServer();
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        UUID uuid = player.getUUID();
        Optional<FoundryxDataStorage.JailRecord> record = storage.getJailRecord(uuid);
        if (record.isEmpty()) {
            return;
        }
        FoundryxDataStorage.JailRecord jailRecord = record.get();
        Long releaseAt = jailRecord.releaseAtMillis();
        if (releaseAt != null && releaseAt <= System.currentTimeMillis()) {
            Optional<FoundryxDataStorage.JailRecord> removed = storage.unjailPlayer(uuid);
            removed.ifPresent(saved -> {
                JailCommands.release(player, saved, storage);
                player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.jail.time_served"));
            });
            JailScheduler.cancelRelease(uuid);
            return;
        }
        Optional destination = Optional.ofNullable(jailRecord.jailLocation()).flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
        destination.ifPresent(target -> TeleportService.teleport(player, target, storage));
        JailCommands.applyJailEffects(player);
        if (releaseAt != null) {
            JailScheduler.scheduleRelease(server, uuid, releaseAt);
        }
    }
}

