/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.storage.FoundryxDataStorage;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class JailRestrictions {
    private static final Map<UUID, Long> LAST_NOTICE = new ConcurrentHashMap<UUID, Long>();
    private static final long NOTICE_INTERVAL_MILLIS = 2000L;

    private JailRestrictions() {
    }

    public static boolean denyIfJailed(ServerPlayer player) {
        UUID uuid;
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return false;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        Optional<FoundryxDataStorage.JailRecord> jailRecord = storage.getJailRecord(uuid = player.getUUID());
        if (jailRecord.isEmpty()) {
            JailRestrictions.clearNotice(player);
            return false;
        }
        long now = System.currentTimeMillis();
        MutableComponent message = JailRestrictions.buildRestrictionMessage(jailRecord, now);
        LAST_NOTICE.compute(uuid, (ignored, previous) -> {
            if (previous == null || now - previous >= 2000L) {
                player.sendSystemMessage((Component)message);
                return now;
            }
            return previous;
        });
        return true;
    }

    public static void clearNotice(ServerPlayer player) {
        LAST_NOTICE.remove(player.getUUID());
    }

    private static MutableComponent buildRestrictionMessage(Optional<FoundryxDataStorage.JailRecord> jailRecord, long now) {
        if (jailRecord.isEmpty()) {
            return Localization.formatted("commands.foundryx.jail.restricted");
        }
        Long releaseAt = jailRecord.get().releaseAtMillis();
        if (releaseAt == null) {
            return Localization.formatted("commands.foundryx.jail.restricted_remaining", Localization.formatted("commands.foundryx.jail.remaining.permanent"));
        }
        long remainingMillis = Math.max(0L, releaseAt - now);
        MutableComponent remaining = Component.literal((String)JailRestrictions.formatDuration(remainingMillis));
        return Localization.formatted("commands.foundryx.jail.restricted_remaining", remaining);
    }

    private static String formatDuration(long millis) {
        long totalSeconds = Math.max(0L, (millis + 999L) / 1000L);
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format(Locale.ROOT, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%02d:%02d", minutes, seconds);
    }
}

