/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.admin.JailCommands;
import com.foundryx.localization.Localization;
import com.foundryx.storage.FoundryxDataStorage;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

final class JailScheduler {
    private static final long RETRY_DELAY_SECONDS = 5L;
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "FoundryX Jail Scheduler");
        thread.setDaemon(true);
        return thread;
    });
    private static final Map<UUID, ScheduledFuture<?>> TASKS = new ConcurrentHashMap();

    private JailScheduler() {
    }

    static void scheduleRelease(MinecraftServer server, UUID playerId, long releaseAtMillis) {
        JailScheduler.cancelRelease(playerId);
        long delay = Math.max(0L, releaseAtMillis - System.currentTimeMillis());
        ScheduledFuture<?> future = EXECUTOR.schedule(() -> server.execute(() -> JailScheduler.attemptRelease(server, playerId, releaseAtMillis)), delay, TimeUnit.MILLISECONDS);
        TASKS.put(playerId, future);
    }

    static void cancelRelease(UUID playerId) {
        ScheduledFuture<?> future = TASKS.remove(playerId);
        if (future != null) {
            future.cancel(false);
        }
    }

    private static void attemptRelease(MinecraftServer server, UUID playerId, long releaseAtMillis) {
        TASKS.remove(playerId);
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        if (!storage.isJailed(playerId)) {
            return;
        }
        ServerPlayer player = server.getPlayerList().getPlayer(playerId);
        if (player == null) {
            ScheduledFuture<?> future = EXECUTOR.schedule(() -> server.execute(() -> JailScheduler.attemptRelease(server, playerId, releaseAtMillis)), 5L, TimeUnit.SECONDS);
            TASKS.put(playerId, future);
            return;
        }
        Optional<FoundryxDataStorage.JailRecord> record = storage.unjailPlayer(playerId);
        if (record.isEmpty()) {
            return;
        }
        JailCommands.release(player, record.get(), storage);
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.jail.time_served"));
    }
}

