/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class KickCommand {
    private KickCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kick").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_KICK))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> KickCommand.kick((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), (Component)Component.translatable((String)"multiplayer.disconnect.kicked"), false))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> KickCommand.kick((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), MessageArgument.getMessage((CommandContext)context, (String)"reason"), true)))));
    }

    private static int kick(CommandContext<CommandSourceStack> context, ServerPlayer target, Component reason, boolean customReason) throws CommandSyntaxException {
        CommandUtil.ensureCanAffect((CommandSourceStack)context.getSource(), target, FoundryxPermission.COMMAND_KICK_EXEMPT, FoundryxPermission.COMMAND_KICK_FORCE);
        target.connection.disconnect(reason);
        MutableComponent successMessage = customReason ? Localization.formatted("commands.foundryx.kick.success.reason", target.getName(), reason) : Localization.formatted("commands.foundryx.kick.success", target.getName());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> KickCommand.lambda$kick$3((Component)successMessage), true);
        MutableComponent notifyMessage = customReason ? Localization.formatted("commands.foundryx.kick.notify.reason", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName(), reason) : Localization.formatted("commands.foundryx.kick.notify", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName());
        CommandUtil.notify((CommandSourceStack)context.getSource(), (Component)notifyMessage, FoundryxPermission.COMMAND_KICK_NOTIFY);
        return 1;
    }

    private static /* synthetic */ Component lambda$kick$3(Component successMessage) {
        return successMessage;
    }
}

