/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class KillCommand {
    private static final SimpleCommandExceptionType NOTHING_TO_KILL = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.kill.failed"));

    private KillCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kill").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_KILL))).executes(context -> KillCommand.kill((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getEntityOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> KillCommand.kill((CommandContext<CommandSourceStack>)context, EntityArgument.getEntity((CommandContext)context, (String)"target")))));
    }

    private static int kill(CommandContext<CommandSourceStack> context, Entity target) throws CommandSyntaxException {
        ServerPlayer player;
        if (!target.isAlive()) {
            throw NOTHING_TO_KILL.create();
        }
        if (target instanceof ServerPlayer) {
            player = (ServerPlayer)target;
            CommandUtil.ensureCanAffect((CommandSourceStack)context.getSource(), player, FoundryxPermission.COMMAND_KILL_EXEMPT, FoundryxPermission.COMMAND_KILL_FORCE);
        }
        target.hurt(((CommandSourceStack)context.getSource()).getLevel().damageSources().genericKill(), Float.MAX_VALUE);
        if (target.isAlive()) {
            throw NOTHING_TO_KILL.create();
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.kill.success", target.getDisplayName()), true);
        if (target instanceof ServerPlayer) {
            player = (ServerPlayer)target;
            CommandUtil.notify((CommandSourceStack)context.getSource(), (Component)Localization.formatted("commands.foundryx.kill.notify", ((CommandSourceStack)context.getSource()).getDisplayName(), player.getName()), FoundryxPermission.COMMAND_KILL_NOTIFY);
        }
        return 1;
    }
}

