/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.command.util.DurationParser;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class MuteCommands {
    private static final DynamicCommandExceptionType INVALID_DURATION = new DynamicCommandExceptionType(input -> Localization.formatted("commands.foundryx.tempmute.invalid_duration", input));

    private MuteCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mute").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_MUTE))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, false, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, false, MessageArgument.getMessage((CommandContext)context, (String)"reason"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mite").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_MUTE))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, false, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, false, MessageArgument.getMessage((CommandContext)context, (String)"reason"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tempmute").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TEMP_MUTE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, true, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> MuteCommands.mute((CommandContext<CommandSourceStack>)context, true, MessageArgument.getMessage((CommandContext)context, (String)"reason")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unmute").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_UNMUTE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(MuteCommands::unmute)));
    }

    private static int mute(CommandContext<CommandSourceStack> context, boolean temporary, Component reason) throws CommandSyntaxException {
        MutableComponent notifyMessage;
        MutableComponent message;
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        if (temporary) {
            CommandUtil.ensureCanAffect((CommandSourceStack)context.getSource(), target, FoundryxPermission.COMMAND_TEMP_MUTE_EXEMPT, FoundryxPermission.COMMAND_TEMP_MUTE_FORCE);
        } else {
            CommandUtil.ensureCanAffect((CommandSourceStack)context.getSource(), target, FoundryxPermission.COMMAND_MUTE_EXEMPT, FoundryxPermission.COMMAND_MUTE_FORCE);
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        long expiry = Long.MAX_VALUE;
        if (temporary) {
            String durationInput = StringArgumentType.getString(context, (String)"duration");
            long durationSeconds = DurationParser.parse(durationInput, INVALID_DURATION);
            try {
                long durationMillis = Math.multiplyExact(durationSeconds, 1000L);
                expiry = Math.addExact(System.currentTimeMillis(), durationMillis);
            }
            catch (ArithmeticException exception) {
                throw INVALID_DURATION.create((Object)durationInput);
            }
        }
        Component durationComponent = temporary ? MuteCommands.durationDescription(expiry) : null;
        String reasonText = reason == null ? null : reason.getString();
        storage.mutePlayer(target.getUUID(), expiry, reasonText);
        if (temporary) {
            message = reason == null ? Localization.formatted("commands.foundryx.tempmute.applied", target.getName(), durationComponent) : Localization.formatted("commands.foundryx.tempmute.applied.reason", target.getName(), durationComponent, reason);
            notifyMessage = reason == null ? Localization.formatted("commands.foundryx.tempmute.notify", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName(), durationComponent) : Localization.formatted("commands.foundryx.tempmute.notify.reason", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName(), durationComponent, reason);
        } else {
            message = reason == null ? Localization.formatted("commands.foundryx.mute.applied", target.getName()) : Localization.formatted("commands.foundryx.mute.applied.reason", target.getName(), reason);
            notifyMessage = reason == null ? Localization.formatted("commands.foundryx.mute.notify", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName()) : Localization.formatted("commands.foundryx.mute.notify.reason", ((CommandSourceStack)context.getSource()).getDisplayName(), target.getName(), reason);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> MuteCommands.lambda$mute$11((Component)message), true);
        if (reason == null) {
            target.sendSystemMessage((Component)(temporary ? Localization.formatted("commands.foundryx.tempmute.notice", durationComponent) : Localization.formatted("commands.foundryx.mute.notice")));
        } else {
            target.sendSystemMessage((Component)(temporary ? Localization.formatted("commands.foundryx.tempmute.notice.reason", durationComponent, reason) : Localization.formatted("commands.foundryx.mute.notice.reason", reason)));
        }
        CommandUtil.notify((CommandSourceStack)context.getSource(), (Component)notifyMessage, temporary ? FoundryxPermission.COMMAND_TEMP_MUTE_NOTIFY : FoundryxPermission.COMMAND_MUTE_NOTIFY);
        return 1;
    }

    private static int unmute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (!storage.isMuted(target.getUUID())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.unmute.not_muted", target.getName()));
            return 0;
        }
        storage.unmutePlayer(target.getUUID());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.unmute.cleared", target.getName()), true);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.unmute.notice"));
        return 1;
    }

    private static Component durationDescription(long expiry) {
        if (expiry == Long.MAX_VALUE) {
            return Localization.formatted("commands.foundryx.tempmute.duration.permanent");
        }
        long seconds = Math.max(1L, (expiry - System.currentTimeMillis()) / 1000L);
        return Localization.formatted("commands.foundryx.tempmute.duration.seconds", seconds);
    }

    private static /* synthetic */ Component lambda$mute$11(Component message) {
        return message;
    }
}

