/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.Constants;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.StorageMigration;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class StorageMigrationCommand {
    private StorageMigrationCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"foundryxstorage").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_STORAGE_MIGRATE))).then(Commands.literal((String)"tojson").executes(StorageMigrationCommand::exportToJson))).then(Commands.literal((String)"todb").executes(StorageMigrationCommand::importToDatabase)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fxstorage").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_STORAGE_MIGRATE))).then(Commands.literal((String)"tojson").executes(StorageMigrationCommand::exportToJson))).then(Commands.literal((String)"todb").executes(StorageMigrationCommand::importToDatabase)));
    }

    private static int exportToJson(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        try {
            StorageMigration.MigrationReport report = StorageMigration.exportToJson(source.getServer(), storage);
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.storage.export.success", report.users(), report.homes(), report.warps(), report.mail(), report.kits(), report.enderChests()), true);
            return report.users();
        }
        catch (StorageMigration.StorageMigrationException exception) {
            StorageMigrationCommand.handleFailure(source, true, exception);
            return 0;
        }
    }

    private static int importToDatabase(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        try {
            StorageMigration.MigrationReport report = StorageMigration.importFromJson(source.getServer(), storage);
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.storage.import.success", report.users(), report.homes(), report.warps(), report.mail(), report.kits(), report.enderChests()), true);
            return report.users();
        }
        catch (StorageMigration.StorageMigrationException exception) {
            StorageMigrationCommand.handleFailure(source, false, exception);
            return 0;
        }
    }

    private static void handleFailure(CommandSourceStack source, boolean exporting, StorageMigration.StorageMigrationException exception) {
        if ("database_unavailable".equals(exception.reason())) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.storage.database_unavailable"));
            return;
        }
        String key = exporting ? "commands.foundryx.storage.export.failed" : "commands.foundryx.storage.import.failed";
        source.sendFailure((Component)Localization.formatted(key, exception.reason()));
        if (exception.getCause() != null) {
            Constants.LOG.error("Storage migration failed", (Throwable)exception);
        }
    }
}

