/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.command.util.DurationParser;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;

public final class TempBanCommand {
    private static final DynamicCommandExceptionType INVALID_DURATION = new DynamicCommandExceptionType(input -> Localization.formatted("commands.foundryx.tempban.invalid_duration", input));
    private static final SimpleCommandExceptionType NO_TARGETS = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.tempban.none"));

    private TempBanCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tempban").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TEMPBAN))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).executes(context -> TempBanCommand.tempban((CommandContext<CommandSourceStack>)context, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> TempBanCommand.tempban((CommandContext<CommandSourceStack>)context, MessageArgument.getMessage((CommandContext)context, (String)"reason")))))));
    }

    private static int tempban(CommandContext<CommandSourceStack> context, Component reason) throws CommandSyntaxException {
        long expiryMillis;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        String durationInput = StringArgumentType.getString(context, (String)"duration");
        long durationSeconds = DurationParser.parse(durationInput, INVALID_DURATION);
        try {
            long durationMillis = Math.multiplyExact(durationSeconds, 1000L);
            expiryMillis = Math.addExact(System.currentTimeMillis(), durationMillis);
        }
        catch (ArithmeticException exception) {
            throw INVALID_DURATION.create((Object)durationInput);
        }
        Date expiry = new Date(expiryMillis);
        MutableComponent durationComponent = Component.literal((String)durationInput);
        UserBanList banList = source.getServer().getPlayerList().getBans();
        int bannedCount = 0;
        for (NameAndId target : targets) {
            ServerPlayer online;
            NameAndId normalized = target.id() != null ? target : NameAndId.createOffline((String)target.name());
            if (banList.isBanned(normalized)) continue;
            ServerPlayer serverPlayer = online = normalized.id() != null ? source.getServer().getPlayerList().getPlayer(normalized.id()) : source.getServer().getPlayerList().getPlayerByName(normalized.name());
            if (online != null) {
                try {
                    CommandUtil.ensureCanAffect(source, online, FoundryxPermission.COMMAND_TEMPBAN_EXEMPT, FoundryxPermission.COMMAND_TEMPBAN_FORCE);
                }
                catch (CommandSyntaxException exception) {
                    if (targets.size() != 1) continue;
                    throw exception;
                }
            }
            String reasonText = reason == null ? null : reason.getString();
            banList.add(new UserBanListEntry(normalized, new Date(), source.getTextName(), expiry, reasonText));
            if (online != null) {
                MutableComponent kickMessage = reason == null ? Localization.formatted("commands.foundryx.tempban.disconnect", durationComponent) : Localization.formatted("commands.foundryx.tempban.disconnect.reason", durationComponent, reason);
                online.connection.disconnect((Component)kickMessage);
            }
            MutableComponent success = reason == null ? Localization.formatted("commands.foundryx.tempban.success", Component.literal((String)target.name()), durationComponent) : Localization.formatted("commands.foundryx.tempban.success.reason", Component.literal((String)target.name()), durationComponent, reason);
            source.sendSuccess(() -> TempBanCommand.lambda$tempban$4((Component)success), true);
            CommandUtil.notify(source, (Component)(reason == null ? Localization.formatted("commands.foundryx.tempban.notify", source.getDisplayName(), Component.literal((String)target.name()), durationComponent) : Localization.formatted("commands.foundryx.tempban.notify.reason", source.getDisplayName(), Component.literal((String)target.name()), durationComponent, reason)), FoundryxPermission.COMMAND_TEMPBAN_NOTIFY);
            ++bannedCount;
        }
        if (bannedCount == 0) {
            throw NO_TARGETS.create();
        }
        return bannedCount;
    }

    private static /* synthetic */ Component lambda$tempban$4(Component success) {
        return success;
    }
}

