/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.IpBanList;

public final class UnbanIpCommand {
    private static final Pattern IP_PATTERN = Pattern.compile("^\\d{1,3}(?:\\.\\d{1,3}){3}$");
    private static final SimpleCommandExceptionType INVALID_IP = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.banip.invalid"));
    private static final SimpleCommandExceptionType NOT_BANNED = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.unbanip.missing"));

    private UnbanIpCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unban-ip").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_UNBAN_IP))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).executes(UnbanIpCommand::unban)));
    }

    private static int unban(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String target = StringArgumentType.getString(context, (String)"target");
        if (!IP_PATTERN.matcher(target).matches()) {
            throw INVALID_IP.create();
        }
        UnbanIpCommand.validateIp(target);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        IpBanList banList = source.getServer().getPlayerList().getIpBans();
        if (!banList.isBanned(target)) {
            throw NOT_BANNED.create();
        }
        banList.remove(target);
        FoundryxDataStorage.get(source.getServer()).getBanDataManager().removeByIp(target);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.unbanip.success", Component.literal((String)target)), true);
        return 1;
    }

    private static void validateIp(String address) throws CommandSyntaxException {
        String[] segments = address.split("\\.");
        if (segments.length != 4) {
            throw INVALID_IP.create();
        }
        for (String segment : segments) {
            try {
                int value = Integer.parseInt(segment);
                if (value >= 0 && value <= 255) continue;
                throw INVALID_IP.create();
            }
            catch (NumberFormatException exception) {
                throw INVALID_IP.create();
            }
        }
    }
}

