/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.managers.VanishManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class VanishCommand {
    private VanishCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(VanishCommand.buildCommand("vanish"));
        dispatcher.register(VanishCommand.buildCommand("v"));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildCommand(String literal) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_VANISH))).executes(context -> VanishCommand.execute(((CommandSourceStack)context.getSource()).getPlayerOrException()));
    }

    private static int execute(ServerPlayer player) {
        boolean enable = !VanishManager.isVanished(player);
        VanishManager.setVanished(player, enable);
        if (enable) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.vanish.enabled"));
        } else {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.vanish.disabled"));
        }
        return 1;
    }
}

