/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.data.PlayerWhoisData;
import com.foundryx.localization.Localization;
import com.foundryx.managers.AfkManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserBanList;
import net.minecraft.world.level.GameType;

public final class WhoisCommand {
    private WhoisCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"whois").requires(source -> source.getEntity() instanceof ServerPlayer && FoundryxPermissions.check(source, FoundryxPermission.COMMAND_WHOIS))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerNamesArray(), (SuggestionsBuilder)builder)).executes(WhoisCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MutableComponent reasonComponent;
        boolean afk;
        boolean canFly;
        boolean operator;
        GameType gameType;
        float saturation;
        int food;
        double maxHealth;
        boolean online;
        UUID uuid;
        ServerPlayer executor = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        MinecraftServer server = executor.level().getServer();
        PlayerList playerList = server.getPlayerList();
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        String input = StringArgumentType.getString(context, (String)"target");
        ServerPlayer targetPlayer = playerList.getPlayerByName(input);
        PlayerWhoisData snapshot = null;
        if (targetPlayer != null) {
            uuid = targetPlayer.getUUID();
            storage.updateWhoisSnapshot(targetPlayer);
            snapshot = storage.getWhoisData(uuid).orElse(null);
        } else {
            Optional<UUID> resolved = storage.findPlayerUuid(input);
            if (resolved.isEmpty()) {
                executor.sendSystemMessage((Component)Localization.formatted("commands.foundryx.whois.not_found", Component.literal((String)input)));
                return 0;
            }
            uuid = resolved.get();
            snapshot = storage.getWhoisData(uuid).orElse(null);
            if (snapshot == null) {
                executor.sendSystemMessage((Component)Localization.formatted("commands.foundryx.whois.not_found", Component.literal((String)input)));
                return 0;
            }
        }
        boolean bl = online = targetPlayer != null;
        double health = online ? (double)targetPlayer.getHealth() : (snapshot != null && snapshot.health() != null ? snapshot.health() : 0.0);
        double d = maxHealth = online ? (double)targetPlayer.getMaxHealth() : 20.0;
        int n = online ? targetPlayer.getFoodData().getFoodLevel() : (food = snapshot != null && snapshot.foodLevel() != null ? snapshot.foodLevel() : 0);
        float f = online ? targetPlayer.getFoodData().getSaturationLevel() : (saturation = snapshot != null && snapshot.saturation() != null ? snapshot.saturation().floatValue() : 0.0f);
        Object object = online ? targetPlayer.gameMode.getGameModeForPlayer() : (gameType = snapshot != null && snapshot.gameModeId() != null ? GameType.byId((int)snapshot.gameModeId()) : null);
        boolean bl2 = online ? targetPlayer.hasPermissions(2) : (operator = snapshot != null && snapshot.operator() != null && snapshot.operator() != false);
        boolean bl3 = online ? targetPlayer.getAbilities().mayfly : (canFly = snapshot != null && snapshot.canFly() != null && snapshot.canFly() != false);
        String ip = online ? targetPlayer.getIpAddress() : (snapshot != null ? snapshot.lastIp() : null);
        long playTime = snapshot != null ? snapshot.totalPlayTime() : 0L;
        Long lastLogin = snapshot != null ? snapshot.lastLogin() : null;
        Long lastSeen = snapshot != null ? snapshot.lastSeen() : null;
        boolean jailed = storage.isJailed(uuid);
        boolean muted = storage.isMuted(uuid);
        Optional<Long> muteExpiry = storage.getMuteExpiry(uuid);
        Optional<String> muteReason = storage.getMuteReason(uuid);
        boolean bl4 = afk = online && AfkManager.isAfk(targetPlayer);
        String targetName = online ? targetPlayer.getScoreboardName() : (snapshot != null && snapshot.lastKnownName() != null ? snapshot.lastKnownName() : input);
        MutableComponent targetDisplay = online ? targetPlayer.getDisplayName().copy() : Component.literal((String)targetName);
        BanInfo banInfo = WhoisCommand.resolveBanInfo(playerList, uuid, ip, targetName);
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        if (online) {
            lines.add(Localization.formatted("commands.foundryx.whois.header.online", targetDisplay));
            lines.add(Localization.formatted("commands.foundryx.whois.health_online", WhoisCommand.formatNumber(health), WhoisCommand.formatNumber(maxHealth)));
            lines.add(Localization.formatted("commands.foundryx.whois.food", food, WhoisCommand.formatNumber(saturation)));
        } else {
            lines.add(Localization.formatted("commands.foundryx.whois.header.offline", targetDisplay));
            if (snapshot != null && snapshot.health() != null) {
                lines.add(Localization.formatted("commands.foundryx.whois.health_offline", WhoisCommand.formatNumber(snapshot.health())));
            }
            if (snapshot != null && snapshot.foodLevel() != null && snapshot.saturation() != null) {
                lines.add(Localization.formatted("commands.foundryx.whois.food", snapshot.foodLevel(), WhoisCommand.formatNumber(snapshot.saturation().floatValue())));
            }
        }
        MutableComponent gameModeComponent = gameType == null ? Localization.formatted("commands.foundryx.whois.unknown") : Component.literal((String)gameType.getName());
        lines.add(Localization.formatted("commands.foundryx.whois.gamemode", gameModeComponent));
        lines.add(Localization.formatted("commands.foundryx.whois.operator", WhoisCommand.formatBoolean(operator)));
        lines.add(Localization.formatted("commands.foundryx.whois.can_fly", WhoisCommand.formatBoolean(canFly)));
        MutableComponent ipComponent = ip == null || ip.isBlank() ? Localization.formatted("commands.foundryx.whois.ip_unknown") : Component.literal((String)ip);
        lines.add(Localization.formatted("commands.foundryx.whois.ip", ipComponent));
        lines.add(Localization.formatted("commands.foundryx.whois.playtime", WhoisCommand.formatDuration(playTime)));
        lines.add(Localization.formatted("commands.foundryx.whois.last_login", WhoisCommand.formatDurationSince(lastLogin)));
        if (!online) {
            lines.add(Localization.formatted("commands.foundryx.whois.last_seen", WhoisCommand.formatDurationSince(lastSeen)));
        }
        lines.add(Localization.formatted("commands.foundryx.whois.afk", WhoisCommand.formatBoolean(afk)));
        lines.add(Localization.formatted("commands.foundryx.whois.jailed", WhoisCommand.formatBoolean(jailed)));
        lines.add(Localization.formatted("commands.foundryx.whois.muted", WhoisCommand.formatBoolean(muted)));
        if (muted) {
            reasonComponent = muteReason.map(Component::literal).orElse(Localization.formatted("commands.foundryx.whois.mute_reason_missing"));
            lines.add(Localization.formatted("commands.foundryx.whois.mute_reason", reasonComponent));
            lines.add(Localization.formatted("commands.foundryx.whois.mute_expires", WhoisCommand.formatExpiry(muteExpiry.orElse(null))));
        }
        lines.add(Localization.formatted("commands.foundryx.whois.banned", WhoisCommand.formatBoolean(banInfo.active())));
        if (banInfo.active()) {
            reasonComponent = banInfo.reason().map(Component::literal).orElse(Localization.formatted("commands.foundryx.whois.ban_reason_missing"));
            lines.add(Localization.formatted("commands.foundryx.whois.ban_reason", reasonComponent));
            lines.add(Localization.formatted("commands.foundryx.whois.ban_expires", WhoisCommand.formatExpiry(banInfo.expiry().orElse(null))));
        }
        executor.sendSystemMessage((Component)WhoisCommand.joinLines(lines));
        return 1;
    }

    private static MutableComponent joinLines(List<MutableComponent> lines) {
        MutableComponent message = Component.empty();
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0) {
                message.append((Component)Component.literal((String)"\n"));
            }
            message.append((Component)lines.get(i));
        }
        return message;
    }

    private static String formatNumber(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }

    private static MutableComponent formatBoolean(boolean value) {
        return Localization.formatted(value ? "commands.foundryx.common.yes" : "commands.foundryx.common.no");
    }

    private static MutableComponent formatDuration(long millis) {
        long duration = Math.max(0L, millis);
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) % 60L;
        return Localization.formatted("commands.foundryx.whois.duration", days, hours, minutes);
    }

    private static MutableComponent formatDurationSince(Long timestamp) {
        if (timestamp == null) {
            return Localization.formatted("commands.foundryx.whois.time_unknown");
        }
        long diff = Math.max(0L, System.currentTimeMillis() - timestamp);
        MutableComponent duration = WhoisCommand.formatDuration(diff);
        return Localization.formatted("commands.foundryx.whois.duration_ago", duration);
    }

    private static MutableComponent formatExpiry(Long timestamp) {
        if (timestamp == null) {
            return Localization.formatted("commands.foundryx.whois.time_unknown");
        }
        if (timestamp <= 0L || timestamp == Long.MAX_VALUE) {
            return Localization.formatted("commands.foundryx.whois.expires.never");
        }
        long remaining = timestamp - System.currentTimeMillis();
        if (remaining <= 0L) {
            return Localization.formatted("commands.foundryx.whois.expires.expired");
        }
        return Localization.formatted("commands.foundryx.whois.expires.in", WhoisCommand.formatDuration(remaining));
    }

    private static BanInfo resolveBanInfo(PlayerList playerList, UUID uuid, String ipAddress, String name) {
        boolean active = WhoisCommand.isUserBanned(playerList, uuid, name);
        if (!active && ipAddress != null && !ipAddress.isBlank()) {
            active = WhoisCommand.isIpBanned(playerList, ipAddress);
        }
        return new BanInfo(active, Optional.empty(), Optional.empty());
    }

    private static boolean isUserBanned(PlayerList playerList, UUID uuid, String name) {
        UserBanList banList = playerList.getBans();
        if (banList == null) {
            return false;
        }
        if (uuid != null && Boolean.TRUE.equals(WhoisCommand.invokeBooleanMethod(banList, "isBanned", UUID.class, uuid))) {
            return true;
        }
        return name != null && Boolean.TRUE.equals(WhoisCommand.invokeBooleanMethod(banList, "isBanned", String.class, name));
    }

    private static boolean isIpBanned(PlayerList playerList, String ipAddress) {
        IpBanList banList = playerList.getIpBans();
        if (banList == null || ipAddress == null || ipAddress.isBlank()) {
            return false;
        }
        return Boolean.TRUE.equals(WhoisCommand.invokeBooleanMethod(banList, "isBanned", String.class, ipAddress));
    }

    private static Boolean invokeBooleanMethod(Object target, String methodName, Class<?> parameterType, Object argument) {
        try {
            Method method = target.getClass().getMethod(methodName, parameterType);
            Object result = method.invoke(target, argument);
            if (result instanceof Boolean) {
                Boolean booleanResult = (Boolean)result;
                return booleanResult;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private record BanInfo(boolean active, Optional<String> reason, Optional<Long> expiry) {
    }
}

