/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.economy;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class EconomyCommand {
    private EconomyCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balance").requires(source -> source.getEntity() instanceof ServerPlayer && FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BALANCE))).executes(EconomyCommand::showSelfBalance)).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BALANCE_OTHERS))).suggests((context, builder) -> SharedSuggestionProvider.suggest(EconomyCommand.getPlayerSuggestions((CommandSourceStack)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> EconomyCommand.showOtherBalance((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pay").requires(source -> source.getEntity() instanceof ServerPlayer && FoundryxPermissions.check(source, FoundryxPermission.COMMAND_PAY))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(EconomyCommand.getPlayerSuggestions((CommandSourceStack)context.getSource()), (SuggestionsBuilder)builder)).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EconomyCommand.payPlayer((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"eco").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_ECO))).then(Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(EconomyCommand.getPlayerSuggestions((CommandSourceStack)context.getSource()), (SuggestionsBuilder)builder)).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> EconomyCommand.setBalance((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(EconomyCommand.getPlayerSuggestions((CommandSourceStack)context.getSource()), (SuggestionsBuilder)builder)).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EconomyCommand.removeBalance((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount")))))));
    }

    private static int showSelfBalance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        double balance = storage.getBalance(player.getUUID());
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.balance.self", EconomyCommand.formatAmount(balance)));
        return 1;
    }

    private static int showOtherBalance(CommandContext<CommandSourceStack> context, String targetName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional<PlayerIdentity> identity = EconomyCommand.resolvePlayer(source, targetName);
        if (identity.isEmpty()) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.economy.target_missing", targetName));
            return 0;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        double balance = storage.getBalance(identity.get().id());
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.economy.balance.other", ((PlayerIdentity)identity.get()).name(), EconomyCommand.formatAmount(balance)), false);
        return 1;
    }

    private static int payPlayer(CommandContext<CommandSourceStack> context, String targetName, double amount) throws CommandSyntaxException {
        ServerPlayer target;
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Optional<PlayerIdentity> identity = EconomyCommand.resolvePlayer((CommandSourceStack)context.getSource(), targetName);
        if (identity.isEmpty()) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.target_missing", targetName));
            return 0;
        }
        if (sender.getUUID().equals(identity.get().id())) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.pay.self"));
            return 0;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (!storage.removeBalance(sender.getUUID(), amount)) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.pay.insufficient"));
            return 0;
        }
        storage.addBalance(identity.get().id(), amount);
        sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.pay.sender", identity.get().name(), EconomyCommand.formatAmount(amount)));
        if (identity.get().online() && (target = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(identity.get().id())) != null) {
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.economy.pay.receiver", EconomyCommand.formatAmount(amount), sender.getName()));
        }
        return 1;
    }

    private static int setBalance(CommandContext<CommandSourceStack> context, String targetName, double amount) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional<PlayerIdentity> identity = EconomyCommand.resolvePlayer(source, targetName);
        if (identity.isEmpty()) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.economy.target_missing", targetName));
            return 0;
        }
        double clamped = Math.max(0.0, amount);
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        storage.setBalance(identity.get().id(), clamped);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.economy.eco.set", ((PlayerIdentity)identity.get()).name(), EconomyCommand.formatAmount(clamped)), true);
        return 1;
    }

    private static int removeBalance(CommandContext<CommandSourceStack> context, String targetName, double amount) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional<PlayerIdentity> identity = EconomyCommand.resolvePlayer(source, targetName);
        if (identity.isEmpty()) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.economy.target_missing", targetName));
            return 0;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        if (!storage.removeBalance(identity.get().id(), amount)) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.economy.eco.insufficient", identity.get().name()));
            return 0;
        }
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.economy.eco.remove", EconomyCommand.formatAmount(amount), ((PlayerIdentity)identity.get()).name()), true);
        return 1;
    }

    private static Optional<PlayerIdentity> resolvePlayer(CommandSourceStack source, String targetName) {
        MinecraftServer server = source.getServer();
        ServerPlayer online = server.getPlayerList().getPlayerByName(targetName);
        if (online != null) {
            return Optional.of(new PlayerIdentity(online.getUUID(), online.getName(), true));
        }
        try {
            UUID uuid = UUID.fromString(targetName);
            return Optional.of(new PlayerIdentity(uuid, (Component)Component.literal((String)targetName), false));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    private static Collection<String> getPlayerSuggestions(CommandSourceStack source) {
        return source.getServer().getPlayerList().getPlayers().stream().map(player -> player.getGameProfile().name()).toList();
    }

    private static String formatAmount(double amount) {
        String currencySymbol = ModConfig.get().economy().currencySymbol();
        return currencySymbol + String.format(Locale.ROOT, "%.2f", amount);
    }

    private record PlayerIdentity(UUID id, Component name, boolean online) {
    }
}

