/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.home;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

final class HomeCommandUtil {
    private static final SuggestionProvider<CommandSourceStack> HOME_SUGGESTIONS = (context, builder) -> {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException ignored) {
            return builder.buildFuture();
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        return SharedSuggestionProvider.suggest(storage.getHomeNames(player.getUUID()), (SuggestionsBuilder)builder);
    };

    private HomeCommandUtil() {
    }

    static SuggestionProvider<CommandSourceStack> homeSuggestions() {
        return HOME_SUGGESTIONS;
    }

    static int setHome(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        storage.setHome(player.getUUID(), name, player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.sethome.saved", name), false);
        return 1;
    }

    static int teleportHome(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        Optional<FoundryxDataStorage.TeleportTarget> destination = storage.getHome(player.getUUID(), name);
        if (destination.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.home.missing", name));
            return 0;
        }
        FoundryxDataStorage.TeleportTarget target = destination.get();
        ModConfig.TeleportSettings settings = ModConfig.get().teleport();
        int delay = Math.max(0, settings.homeTeleportDelay());
        boolean cancelOnMove = settings.cancelTeleportOnMove();
        boolean cancelOnDamage = settings.cancelTeleportOnDamage();
        if (delay <= 0) {
            if (TeleportService.teleport(player, target, storage)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.home.teleported", name), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TeleportDelayManager manager = TeleportDelayManager.get(source.getServer());
        manager.scheduleTeleport(player, delay, cancelOnMove, cancelOnDamage, teleported -> {
            if (TeleportService.teleport(teleported, target, storage)) {
                source.sendSuccess(() -> Localization.formatted("commands.foundryx.home.teleported", name), false);
            } else {
                source.sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
            }
        }, () -> {});
        return 1;
    }

    static int deleteHome(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.deleteHome(player.getUUID(), name)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.delhome.removed", name), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.home.missing", name));
        return 0;
    }

    static int listHomes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        Collection<String> homes = storage.getHomeNames(player.getUUID());
        if (homes.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.homes.empty"), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.homes.list", String.join((CharSequence)", ", homes)), false);
        }
        return homes.size();
    }
}

