/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.kit;

import com.foundryx.command.util.DurationParser;
import com.foundryx.data.KitData;
import com.foundryx.localization.Localization;
import com.foundryx.managers.KitManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.KitStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public final class CreateKitCommand {
    private static final SimpleCommandExceptionType NO_ITEMS = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.createkit.no_items"));
    private static final DynamicCommandExceptionType INVALID_DURATION = new DynamicCommandExceptionType(input -> Localization.formatted("commands.foundryx.createkit.invalid_duration", input));

    private CreateKitCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"createkit").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_CREATE_KIT))).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> CreateKitCommand.createKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), 0L, null))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String cooldownInput = StringArgumentType.getString((CommandContext)context, (String)"cooldown");
            long cooldownSeconds = DurationParser.parse(cooldownInput, INVALID_DURATION);
            return CreateKitCommand.createKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), cooldownSeconds, cooldownInput);
        }))));
    }

    private static int createKit(CommandContext<CommandSourceStack> context, String kitName, long cooldownSeconds, String cooldownInput) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        List<ItemStack> items = CreateKitCommand.collectItems(player);
        if (items.isEmpty()) {
            throw NO_ITEMS.create();
        }
        KitStorage storage = KitStorage.get(((CommandSourceStack)context.getSource()).getServer());
        KitData kit = storage.saveKit(kitName, items, cooldownSeconds);
        if (cooldownSeconds > 0L && cooldownInput != null) {
            MutableComponent message = Localization.formatted("commands.foundryx.createkit.saved", kit.name(), Component.literal((String)cooldownInput));
            player.sendSystemMessage((Component)message);
        } else {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.createkit.saved_no_cooldown", kit.name()));
        }
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.createkit.permission", KitManager.permissionNode(kit.name())));
        return kit.items().size();
    }

    private static List<ItemStack> collectItems(ServerPlayer player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Inventory inventory = player.getInventory();
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            ItemStack stack = inventory.getItem(slot);
            if (stack.isEmpty()) continue;
            items.add(stack.copy());
        }
        return items;
    }
}

