/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.kit;

import com.foundryx.localization.Localization;
import com.foundryx.managers.KitManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public final class DeleteKitCommand {
    private static final SuggestionProvider<CommandSourceStack> KIT_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest(KitManager.getKitNames(), (SuggestionsBuilder)builder);

    private DeleteKitCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delkit").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_DELETE_KIT))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(KIT_SUGGESTIONS).executes(context -> DeleteKitCommand.deleteKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))));
    }

    private static int deleteKit(CommandContext<CommandSourceStack> context, String name) {
        boolean removed = KitManager.deleteKit(name);
        if (!removed) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.delkit.not_found", name));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.delkit.deleted", name), true);
        return 1;
    }
}

