/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.data.EnderChestData;
import com.foundryx.localization.Localization;
import com.foundryx.managers.EnderChestManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;

public final class EnderChestCommand {
    private EnderChestCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(EnderChestCommand.buildLiteral("enderchest"));
        dispatcher.register(EnderChestCommand.buildLiteral("ec"));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildLiteral(String literal) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(source -> EnderChestCommand.hasEnderChestPermission(source))).executes(EnderChestCommand::openOwn)).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests(EnderChestCommand::suggestOnlinePlayers).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_ENDERCHEST_OTHER))).executes(EnderChestCommand::openOther));
    }

    private static int openOwn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        EnderChestData data = EnderChestManager.get(player);
        boolean hasLarge = FoundryxPermissions.check(player, FoundryxPermission.COMMAND_ENDERCHEST_LARGE);
        boolean hasSmall = FoundryxPermissions.check(player, FoundryxPermission.COMMAND_ENDERCHEST_SMALL);
        if (!hasLarge && !hasSmall) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.enderchest.no_permission"));
            return 0;
        }
        data.setHasLargeEnderChest(hasLarge);
        EnderChestManager.save(player, data);
        player.openMenu(EnderChestCommand.createMenuProvider(data, hasLarge, (Component)Localization.formatted("commands.foundryx.enderchest.title.self")));
        return 1;
    }

    private static int openOther(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean targetHasLarge;
        EnderChestData data;
        ServerPlayer viewer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String targetName = StringArgumentType.getString(context, (String)"target");
        MinecraftServer server = viewer.level().getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer != null) {
            data = EnderChestManager.get(targetPlayer);
            targetHasLarge = FoundryxPermissions.check(targetPlayer, FoundryxPermission.COMMAND_ENDERCHEST_LARGE);
            data.setHasLargeEnderChest(targetHasLarge);
            EnderChestManager.save(targetPlayer, data);
        } else {
            data = EnderChestManager.getByName(server, targetName);
            if (data == null) {
                viewer.sendSystemMessage((Component)Localization.formatted("commands.foundryx.enderchest.target_missing", targetName));
                return 0;
            }
            targetHasLarge = data.hasLargeEnderChest();
        }
        viewer.openMenu(EnderChestCommand.createMenuProvider(data, targetHasLarge, (Component)Localization.formatted("commands.foundryx.enderchest.title.other", targetName)));
        viewer.sendSystemMessage((Component)Localization.formatted("commands.foundryx.enderchest.opened_other", targetName));
        return 1;
    }

    private static MenuProvider createMenuProvider(final EnderChestData data, final boolean large, final Component title) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return title;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return large ? ChestMenu.sixRows((int)containerId, (Inventory)inventory, (Container)data.getLargeContainer()) : ChestMenu.threeRows((int)containerId, (Inventory)inventory, (Container)data.getSmallContainer());
            }
        };
    }

    private static boolean hasEnderChestPermission(CommandSourceStack source) {
        return FoundryxPermissions.check(source, FoundryxPermission.COMMAND_ENDERCHEST_SMALL) || FoundryxPermissions.check(source, FoundryxPermission.COMMAND_ENDERCHEST_LARGE);
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getServer() == null) {
            return builder.buildFuture();
        }
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            builder.suggest(player.getScoreboardName());
        }
        return builder.buildFuture();
    }
}

