/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class FeedCommand {
    private FeedCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"feed").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FEED))).executes(context -> FeedCommand.feed((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FEED_OTHERS))).executes(context -> FeedCommand.feed((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))));
    }

    private static int feed(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer executor;
        boolean self;
        target.getFoodData().eat(20, 1.0f);
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        boolean bl = self = entity instanceof ServerPlayer && (executor = (ServerPlayer)entity).getUUID().equals(target.getUUID());
        if (self) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.feed.self"), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.feed.other", target.getName()), true);
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.feed.notice", ((CommandSourceStack)context.getSource()).getDisplayName()));
        }
        return 1;
    }
}

