/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public final class HatCommand {
    private static final SimpleCommandExceptionType EMPTY_HAND = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.hat.empty"));

    private HatCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hat").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_HAT))).executes(HatCommand::swap));
    }

    private static int swap(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack inHand = player.getMainHandItem();
        if (inHand.isEmpty()) {
            throw EMPTY_HAND.create();
        }
        ItemStack hat = inHand.copyWithCount(1);
        ItemStack existing = player.getItemBySlot(EquipmentSlot.HEAD);
        player.setItemSlot(EquipmentSlot.HEAD, hat);
        if (inHand.getCount() <= 1) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        } else {
            inHand.shrink(1);
        }
        if (!existing.isEmpty()) {
            player.getInventory().placeItemBackInInventory(existing);
        }
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.hat.success"));
        return 1;
    }
}

