/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.localization.Localization;
import com.foundryx.managers.KitManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class KitCommand {
    private static final SuggestionProvider<CommandSourceStack> KIT_SUGGESTIONS = (context, builder) -> {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException exception) {
            return builder.buildFuture();
        }
        return SharedSuggestionProvider.suggest(KitCommand.accessibleKitNames(player), (SuggestionsBuilder)builder);
    };

    private KitCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(source -> source.isPlayer() && FoundryxPermission.COMMAND_KIT.check((CommandSourceStack)source))).executes(KitCommand::listKits)).then(Commands.argument((String)"kit", (ArgumentType)StringArgumentType.word()).suggests(KIT_SUGGESTIONS).executes(context -> KitCommand.giveKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"kit")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kits").requires(source -> source.isPlayer() && FoundryxPermission.COMMAND_KIT.check((CommandSourceStack)source))).executes(KitCommand::listKits));
    }

    private static int listKits(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        List<String> defined = KitManager.getKitNames();
        if (defined.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.kit.none_available"), false);
            return 0;
        }
        List<String> accessible = KitCommand.accessibleKitNames(player);
        if (accessible.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.kit.none_accessible"), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.kit.list", String.join((CharSequence)", ", accessible)), false);
        return accessible.size();
    }

    private static int giveKit(CommandContext<CommandSourceStack> context, String kitName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        KitManager.KitDefinition kit = KitManager.getKit(kitName);
        if (kit == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.kit.not_found", kitName));
            return 0;
        }
        if (!KitCommand.hasKitPermission(player, kit)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.kit.no_access", kit.name()));
            return 0;
        }
        long remaining = KitManager.getRemainingCooldown(player, kit);
        if (remaining > 0L) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.kit.cooldown", remaining, kit.name()));
            return 0;
        }
        KitManager.giveKit(player, kit);
        KitManager.recordUsage(player, kit);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.kit.received", kit.name()), false);
        return kit.items().size();
    }

    private static List<String> accessibleKitNames(ServerPlayer player) {
        return KitManager.getKits().stream().filter(kit -> KitCommand.hasKitPermission(player, kit)).map(KitManager.KitDefinition::name).sorted(String::compareToIgnoreCase).toList();
    }

    private static boolean hasKitPermission(ServerPlayer player, KitManager.KitDefinition kit) {
        String node = KitManager.permissionNode(kit);
        return FoundryxPermissions.check(player, node, 0, false);
    }
}

