/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public final class NearCommand {
    private NearCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"near").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_NEAR))).executes(context -> NearCommand.showNearbyPlayers((CommandSourceStack)context.getSource())));
    }

    private static int showNearbyPlayers(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ModConfig.NearSettings settings = ModConfig.get().near();
        int radius = Math.max(1, settings.radius());
        double radiusSquared = (double)radius * (double)radius;
        ServerLevel level = source.getLevel();
        AABB searchArea = player.getBoundingBox().inflate((double)radius);
        List nearbyPlayers = level.getEntitiesOfClass(ServerPlayer.class, searchArea, other -> other != player && player.distanceToSqr((Entity)other) <= radiusSquared);
        nearbyPlayers.sort(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).distanceToSqr(arg_0)));
        if (nearbyPlayers.isEmpty()) {
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.near.none", radius), false);
            return 0;
        }
        Component names = ComponentUtils.formatList((Collection)nearbyPlayers, Player::getDisplayName);
        if (nearbyPlayers.size() == 1) {
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.near.single", radius, names), false);
        } else {
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.near.result", nearbyPlayers.size(), radius, names), false);
        }
        return nearbyPlayers.size();
    }
}

