/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.command.server.TabCommand;
import com.foundryx.localization.Localization;
import com.foundryx.managers.TabManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;

public final class NickCommand {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("(?i)#[0-9A-F]{6}");
    private static final int MAX_NICKNAME_LENGTH = 32;

    private NickCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nick").requires(NickCommand::hasAnyNickPermission)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(NickCommand::hasAnyNickPermission)).executes(NickCommand::resetSelf)).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_NICK_RESET_OTHERS))).executes(context -> NickCommand.resetOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_NICK))).executes(NickCommand::setNickname)));
    }

    private static boolean hasAnyNickPermission(CommandSourceStack source) {
        return FoundryxPermissions.check(source, FoundryxPermission.COMMAND_NICK) || FoundryxPermissions.check(source, FoundryxPermission.COMMAND_NICK_RESET_OTHERS);
    }

    private static int setNickname(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean allowFormats;
        boolean allowColors;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        String rawNickname = StringArgumentType.getString(context, (String)"nickname");
        String sanitized = NickCommand.sanitizeNickname(rawNickname, allowColors = FoundryxPermissions.check(player, FoundryxPermission.COMMAND_NICK_COLOR), allowFormats = FoundryxPermissions.check(player, FoundryxPermission.COMMAND_NICK_FORMAT));
        if (StringUtil.isNullOrEmpty((String)sanitized)) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.invalid"));
            return 0;
        }
        String visible = NickCommand.stripFormatting(sanitized).trim();
        if (visible.isEmpty()) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.invalid"));
            return 0;
        }
        if (visible.codePointCount(0, visible.length()) > 32) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.too_long", 32));
            return 0;
        }
        storage.setNickname(player.getUUID(), sanitized);
        TabManager.updateTabName(player);
        TabCommand.reload(((CommandSourceStack)context.getSource()).getServer());
        MutableComponent preview = NickCommand.nicknamePreview(sanitized);
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.set", preview));
        return 1;
    }

    private static int resetSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!FoundryxPermissions.check(player, FoundryxPermission.COMMAND_NICK)) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.no_permission"));
            return 0;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.getNickname(player.getUUID()).isEmpty()) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.not_set"));
            return 0;
        }
        storage.setNickname(player.getUUID(), null);
        TabManager.updateTabName(player);
        TabCommand.reload(((CommandSourceStack)context.getSource()).getServer());
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.reset"));
        return 1;
    }

    private static int resetOther(CommandContext<CommandSourceStack> context, ServerPlayer target) {
        UUID targetId;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer executor = source.getPlayer();
        FoundryxDataStorage storage = FoundryxDataStorage.get(source.getServer());
        Optional<String> current = storage.getNickname(targetId = target.getUUID());
        if (current.isEmpty()) {
            MutableComponent message = Localization.formatted("commands.foundryx.nick.reset.other.not_set", target.getName());
            if (executor != null) {
                executor.sendSystemMessage((Component)message);
            } else {
                source.sendFailure((Component)message);
            }
            return 0;
        }
        storage.setNickname(targetId, null);
        TabManager.updateTabName(target);
        TabCommand.reload(((CommandSourceStack)context.getSource()).getServer());
        MutableComponent confirmation = Localization.formatted("commands.foundryx.nick.reset.other", target.getName());
        if (executor != null) {
            executor.sendSystemMessage((Component)confirmation);
        } else {
            source.sendSuccess(() -> confirmation, false);
        }
        Component actorName = executor != null ? executor.getName() : source.getDisplayName();
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.nick.reset.other.notify", actorName));
        return 1;
    }

    private static String sanitizeNickname(String input, boolean allowColor, boolean allowFormat) {
        if (input == null) {
            return "";
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < trimmed.length(); ++i) {
            char current = trimmed.charAt(i);
            if ((current == '&' || current == '\u00a7') && i + 1 < trimmed.length()) {
                char next = trimmed.charAt(i + 1);
                if (next == '#') {
                    String hex;
                    if (i + 7 < trimmed.length() && HEX_COLOR_PATTERN.matcher(hex = trimmed.substring(i + 2, i + 8)).matches()) {
                        if (allowColor) {
                            builder.append('\u00a7').append('#').append(hex.toLowerCase(Locale.ROOT));
                        }
                        i += 7;
                        continue;
                    }
                } else {
                    char lower = Character.toLowerCase(next);
                    if (NickCommand.isLegacyColor(lower)) {
                        if (allowColor) {
                            builder.append('\u00a7').append(lower);
                        }
                        ++i;
                        continue;
                    }
                    if (NickCommand.isLegacyFormat(lower)) {
                        if (allowFormat) {
                            builder.append('\u00a7').append(lower);
                        }
                        ++i;
                        continue;
                    }
                }
            }
            if (current == '<' || current == '>' || Character.isISOControl(current)) continue;
            builder.append(current);
        }
        return builder.toString().trim();
    }

    private static String stripFormatting(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char current = value.charAt(i);
            if (current == '\u00a7' && i + 1 < value.length()) {
                char next = value.charAt(i + 1);
                if (next == '#' && i + 7 < value.length()) {
                    i += 7;
                    continue;
                }
                char lower = Character.toLowerCase(next);
                if (NickCommand.isLegacyColor(lower) || NickCommand.isLegacyFormat(lower)) {
                    ++i;
                    continue;
                }
            }
            builder.append(current);
        }
        return builder.toString();
    }

    private static boolean isLegacyColor(char code) {
        return code >= '0' && code <= '9' || code >= 'a' && code <= 'f';
    }

    private static boolean isLegacyFormat(char code) {
        return code == 'k' || code == 'l' || code == 'm' || code == 'n' || code == 'o' || code == 'r';
    }

    private static MutableComponent nicknamePreview(String nickname) {
        Component parsed = ChatFormatter.legacyToComponent(nickname);
        if (parsed instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)parsed;
            return mutable.copy();
        }
        if (parsed != null) {
            return parsed.copy();
        }
        return Component.literal((String)nickname);
    }
}

