/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.localization.Localization;
import com.foundryx.managers.TabManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class RealNameCommand {
    private RealNameCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"realname").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REALNAME))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.greedyString()).suggests(RealNameCommand::suggestTargets).executes(context -> RealNameCommand.execute((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target")))));
    }

    private static CompletableFuture<Suggestions> suggestTargets(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        if (server == null) {
            return builder.buildFuture();
        }
        TreeSet<String> suggestions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            suggestions.add(player.getScoreboardName());
            suggestions.add(ChatFormatter.sanitizeDisplayName(player).getString());
            suggestions.add(ChatFormatter.formatDisplayName(player).getString());
            suggestions.add(TabManager.getDisplay(player).getString());
        }
        suggestions.removeIf(value -> value == null || value.isBlank());
        suggestions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int execute(CommandContext<CommandSourceStack> context, String rawInput) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.getServer();
        if (server == null) {
            return 0;
        }
        String normalizedInput = RealNameCommand.normalize(rawInput);
        if (normalizedInput.isEmpty()) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.realname.invalid"));
            return 0;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            String realName = player.getScoreboardName();
            String normalizedReal = RealNameCommand.normalize(realName);
            if (normalizedReal.equals(normalizedInput)) {
                source.sendSuccess(() -> Localization.formatted("commands.foundryx.realname.no_nickname", player.getName()), true);
                return 1;
            }
            MutableComponent sanitizedDisplay = ChatFormatter.sanitizeDisplayName(player);
            String sanitizedString = sanitizedDisplay.getString();
            String displayName = player.getDisplayName().getString();
            String formattedDisplay = ChatFormatter.formatDisplayName(player).getString();
            Component tabDisplay = TabManager.getDisplay(player);
            String tabString = tabDisplay.getString();
            if (!RealNameCommand.matches(sanitizedString, normalizedInput) && !RealNameCommand.matches(displayName, normalizedInput) && !RealNameCommand.matches(formattedDisplay, normalizedInput) && !RealNameCommand.matches(tabString, normalizedInput)) continue;
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.realname.result", sanitizedDisplay.copy(), player.getName()), true);
            return 1;
        }
        source.sendFailure((Component)Localization.formatted("commands.foundryx.realname.not_found", rawInput));
        return 0;
    }

    private static boolean matches(String candidate, String normalizedInput) {
        if (candidate == null) {
            return false;
        }
        String normalized = RealNameCommand.normalize(candidate);
        return !normalized.isEmpty() && normalized.equals(normalizedInput);
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return RealNameCommand.stripFormatting(value).toLowerCase(Locale.ROOT).trim();
    }

    private static String stripFormatting(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            if ((character == '\u00a7' || character == '&') && i + 1 < value.length()) {
                char next = value.charAt(i + 1);
                if (next == '#') {
                    int remaining = Math.min(7, value.length() - (i + 1));
                    i += remaining;
                    continue;
                }
                ++i;
                continue;
            }
            builder.append(character);
        }
        return builder.toString();
    }
}

