/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.player;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public final class RepairCommand {
    private static final SimpleCommandExceptionType EMPTY_HAND = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.repair.hand.empty"));
    private static final SimpleCommandExceptionType NOT_DAMAGEABLE = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.repair.hand.not_damageable"));
    private static final SimpleCommandExceptionType NO_PERMISSION = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.repair.hand.no_permission"));

    private RepairCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(RepairCommand.buildLiteral());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildLiteral() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"repair").requires(RepairCommand::hasAnyRepairPermission)).executes(RepairCommand::repairMainHand)).then(((LiteralArgumentBuilder)Commands.literal((String)"all").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR_ALL))).executes(RepairCommand::repairAll))).then(((LiteralArgumentBuilder)Commands.literal((String)"armor").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR_ARMOR))).executes(RepairCommand::repairArmor));
    }

    private static boolean hasAnyRepairPermission(CommandSourceStack source) {
        return FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR) || FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR_ALL) || FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR_ARMOR);
    }

    private static int repairMainHand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!FoundryxPermissions.check(source, FoundryxPermission.COMMAND_REPAIR)) {
            throw NO_PERMISSION.create();
        }
        ServerPlayer player = source.getPlayerOrException();
        ItemStack inHand = player.getMainHandItem();
        if (inHand.isEmpty()) {
            throw EMPTY_HAND.create();
        }
        if (!inHand.isDamageableItem()) {
            throw NOT_DAMAGEABLE.create();
        }
        inHand.setDamageValue(0);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.repair.hand.success"), true);
        return 1;
    }

    private static int repairAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Inventory inventory = player.getInventory();
        int containerSize = inventory.getContainerSize();
        int repaired = 0;
        int mainSlots = Math.min(36, containerSize);
        for (int slot = 0; slot < mainSlots; ++slot) {
            if (!RepairCommand.repairStack(inventory.getItem(slot))) continue;
            ++repaired;
        }
        int offhandSlot = containerSize - 1;
        int armorEnd = Math.min(mainSlots + 4, containerSize);
        if (offhandSlot >= armorEnd && offhandSlot < containerSize && RepairCommand.repairStack(inventory.getItem(offhandSlot))) {
            ++repaired;
        }
        if (repaired == 0) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.repair.all.none"));
            return 0;
        }
        int total = repaired;
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.repair.all.success", total), true);
        return total;
    }

    private static int repairArmor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Inventory inventory = player.getInventory();
        int containerSize = inventory.getContainerSize();
        int mainSlots = Math.min(36, containerSize);
        int armorEnd = Math.min(mainSlots + 4, containerSize);
        int repaired = 0;
        for (int slot = mainSlots; slot < armorEnd; ++slot) {
            if (!RepairCommand.repairStack(inventory.getItem(slot))) continue;
            ++repaired;
        }
        if (repaired == 0) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.repair.armor.none"));
            return 0;
        }
        int total = repaired;
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.repair.armor.success", total), true);
        return total;
    }

    private static boolean repairStack(ItemStack stack) {
        if (stack.isEmpty() || !stack.isDamageableItem() || stack.getDamageValue() == 0) {
            return false;
        }
        stack.setDamageValue(0);
        return true;
    }
}

