/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public final class EffectCommand {
    private static final int DEFAULT_DURATION_SECONDS = 30;
    private static final SimpleCommandExceptionType NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.effect.no_targets"));
    private static final DynamicCommandExceptionType UNKNOWN_EFFECT = new DynamicCommandExceptionType(id -> Localization.formatted("commands.foundryx.effect.unknown", id));

    private EffectCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"effect").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_EFFECT))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(EffectCommand::clearSelf)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> EffectCommand.clearOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"effect", (ArgumentType)ResourceLocationArgument.id()).executes(context -> EffectCommand.applySelf((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), 30, 0, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000)).executes(context -> EffectCommand.applySelf((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), 0, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"amplifier", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(context -> EffectCommand.applySelf((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier"), false))).then(Commands.argument((String)"hideParticles", (ArgumentType)BoolArgumentType.bool()).executes(context -> EffectCommand.applySelf((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier"), BoolArgumentType.getBool((CommandContext)context, (String)"hideParticles")))))))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"clear").executes(context -> EffectCommand.clearOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"effect", (ArgumentType)ResourceLocationArgument.id()).executes(context -> EffectCommand.applyOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), 30, 0, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000)).executes(context -> EffectCommand.applyOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), 0, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"amplifier", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(context -> EffectCommand.applyOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier"), false))).then(Commands.argument((String)"hideParticles", (ArgumentType)BoolArgumentType.bool()).executes(context -> EffectCommand.applyOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier"), BoolArgumentType.getBool((CommandContext)context, (String)"hideParticles")))))))));
    }

    private static int clearSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!player.removeAllEffects()) {
            throw NOTHING_HAPPENED.create();
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.effect.clear.single", player.getDisplayName()), true);
        return 1;
    }

    private static int clearOther(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        if (!target.removeAllEffects()) {
            throw NOTHING_HAPPENED.create();
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.effect.clear.single", target.getDisplayName()), true);
        if (((CommandSourceStack)context.getSource()).getEntity() != target) {
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.effect.notice.cleared.by", ((CommandSourceStack)context.getSource()).getDisplayName()));
        }
        return 1;
    }

    private static int applySelf(CommandContext<CommandSourceStack> context, ResourceLocation effectId, int seconds, int amplifier, boolean hideParticles) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return EffectCommand.applyEffect(context, player, effectId, seconds, amplifier, hideParticles);
    }

    private static int applyOther(CommandContext<CommandSourceStack> context, ServerPlayer target, ResourceLocation effectId, int seconds, int amplifier, boolean hideParticles) throws CommandSyntaxException {
        return EffectCommand.applyEffect(context, target, effectId, seconds, amplifier, hideParticles);
    }

    private static int applyEffect(CommandContext<CommandSourceStack> context, ServerPlayer target, ResourceLocation effectId, int seconds, int amplifier, boolean hideParticles) throws CommandSyntaxException {
        Holder<MobEffect> effectHolder = EffectCommand.resolveEffect(effectId);
        MobEffect effect = (MobEffect)effectHolder.value();
        int clampedSeconds = Math.max(seconds, 1);
        int durationTicks = effect.isInstantenous() ? clampedSeconds : clampedSeconds * 20;
        int clampedAmplifier = Mth.clamp((int)amplifier, (int)0, (int)255);
        boolean showParticles = !hideParticles;
        target.addEffect(new MobEffectInstance(effectHolder, durationTicks, clampedAmplifier, false, showParticles));
        MutableComponent effectName = Component.translatable((String)effect.getDescriptionId());
        int displayedLevel = clampedAmplifier + 1;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> EffectCommand.lambda$applyEffect$14((Component)effectName, target, clampedSeconds, displayedLevel), true);
        if (((CommandSourceStack)context.getSource()).getEntity() != target) {
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.effect.notice.applied.by", ((CommandSourceStack)context.getSource()).getDisplayName(), effectName, clampedSeconds, displayedLevel));
        }
        return 1;
    }

    private static Holder<MobEffect> resolveEffect(ResourceLocation effectId) throws CommandSyntaxException {
        MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.getOptional(effectId).orElseThrow(() -> UNKNOWN_EFFECT.create((Object)effectId.toString()));
        return BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect);
    }

    private static /* synthetic */ Component lambda$applyEffect$14(Component effectName, ServerPlayer target, int clampedSeconds, int displayedLevel) {
        return Localization.formatted("commands.foundryx.effect.give.single", effectName, target.getDisplayName(), clampedSeconds, displayedLevel);
    }
}

