/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public final class HelpCommand {
    private static final List<HelpSection> SECTIONS = List.of(new HelpSection("commands.foundryx.help.category.navigation", List.of(new HelpEntry("/spawn", "/spawn", "commands.foundryx.help.spawn"), new HelpEntry("/setspawn", "/setspawn", "commands.foundryx.help.setspawn"), new HelpEntry("/sethome <name>", "/sethome ", "commands.foundryx.help.sethome"), new HelpEntry("/home <name>", "/home ", "commands.foundryx.help.home"), new HelpEntry("/homes", "/homes", "commands.foundryx.help.homes"), new HelpEntry("/back", "/back", "commands.foundryx.help.back"))), new HelpSection("commands.foundryx.help.category.warps", List.of(new HelpEntry("/setwarp <name>", "/setwarp ", "commands.foundryx.help.setwarp"), new HelpEntry("/warp <name>", "/warp ", "commands.foundryx.help.warp"), new HelpEntry("/delwarp <name>", "/delwarp ", "commands.foundryx.help.delwarp"), new HelpEntry("/warps", "/warps", "commands.foundryx.help.warps"))), new HelpSection("commands.foundryx.help.category.utility", List.of(new HelpEntry("/heal", "/heal", "commands.foundryx.help.heal"), new HelpEntry("/feed", "/feed", "commands.foundryx.help.feed"), new HelpEntry("/fly", "/fly", "commands.foundryx.help.fly"), new HelpEntry("/hat", "/hat", "commands.foundryx.help.hat"), new HelpEntry("/repair [all|armor]", "/repair ", "commands.foundryx.help.repair"), new HelpEntry("/afk", "/afk", "commands.foundryx.help.afk"))), new HelpSection("commands.foundryx.help.category.economy", List.of(new HelpEntry("/balance", "/balance", "commands.foundryx.help.balance"), new HelpEntry("/pay <player> <amount>", "/pay ", "commands.foundryx.help.pay"))), new HelpSection("commands.foundryx.help.category.communication", List.of(new HelpEntry("/msg <player> <message>", "/msg ", "commands.foundryx.help.msg"), new HelpEntry("/mail", "/mail", "commands.foundryx.help.mail"), new HelpEntry("/helpop <message>", "/helpop ", "commands.foundryx.help.helpop"), new HelpEntry("/tpa <player>", "/tpa ", "commands.foundryx.help.tpa"), new HelpEntry("/tpaccept", "/tpaccept", "commands.foundryx.help.tpaccept"), new HelpEntry("/tpdeny", "/tpdeny", "commands.foundryx.help.tpdeny"))));

    private HelpCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"help").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_HELP))).executes(HelpCommand::showHelp));
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.help.header").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.help.subtitle").withStyle(ChatFormatting.YELLOW), false);
        for (HelpSection section2 : SECTIONS) {
            source.sendSuccess(Component::empty, false);
            source.sendSuccess(() -> Localization.formatted(section2.titleKey()).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}), false);
            for (HelpEntry entry : section2.entries()) {
                source.sendSuccess(() -> HelpCommand.createEntryLine(entry), false);
            }
        }
        return SECTIONS.stream().mapToInt(section -> section.entries().size()).sum();
    }

    private static Component createEntryLine(HelpEntry entry) {
        MutableComponent commandComponent = Component.literal((String)entry.display()).withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand(entry.suggestion())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Localization.formatted("commands.foundryx.help.hover", entry.suggestion()))).withInsertion(entry.suggestion()));
        MutableComponent description = Localization.formatted(entry.descriptionKey());
        return Component.literal((String)" \u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)commandComponent).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)description);
    }

    private record HelpSection(String titleKey, List<HelpEntry> entries) {
    }

    private record HelpEntry(String display, String suggestion, String descriptionKey) {
    }
}

