/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class HelpopCommand {
    private HelpopCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"helpop").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_HELPOP))).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(HelpopCommand::send)));
    }

    private static int send(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Component message = MessageArgument.getMessage(context, (String)"message");
        if (message.getString().trim().isEmpty()) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.empty"));
            return 0;
        }
        boolean delivered = false;
        for (ServerPlayer target : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
            if (target == sender || !FoundryxPermissions.check(target, FoundryxPermission.COMMAND_HELPOP_REPLY)) continue;
            MutableComponent notification = Localization.formatted("commands.foundryx.helpop.received", sender.getName(), message);
            String suggestion = "/helpopreply " + sender.getName().getString() + " ";
            MutableComponent replyButton = Localization.formatted("commands.foundryx.helpop.reply.button").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand(suggestion)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Localization.formatted("commands.foundryx.helpop.reply.hover"))).withColor(ChatFormatting.GREEN));
            MutableComponent replyPrompt = Localization.formatted("commands.foundryx.helpop.reply.prompt").append((Component)Component.literal((String)" ")).append((Component)replyButton);
            target.sendSystemMessage((Component)notification);
            target.sendSystemMessage((Component)replyPrompt);
            delivered = true;
        }
        if (delivered) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.sent"));
        } else {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.no_listeners"));
        }
        return delivered ? 1 : 0;
    }
}

