/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class HelpopReplyCommand {
    private HelpopReplyCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"helpopreply").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_HELPOP_REPLY))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(HelpopReplyCommand::reply))));
    }

    private static int reply(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        Component message = MessageArgument.getMessage(context, (String)"message");
        if (message.getString().trim().isEmpty()) {
            sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.reply.empty"));
            return 0;
        }
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.reply.received", sender.getName(), message));
        sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.helpop.reply.sent", target.getName(), message));
        return 1;
    }
}

