/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.managers.VanishManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.permission.LuckPermsMetaUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public final class ListCommand {
    private static final String DEFAULT_GROUP = "default";
    private static final Component SPACE = Component.literal((String)" ");
    private static final String HIDDEN_TAG = "foundryx_hidden";

    private ListCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_LIST))).executes(context -> ListCommand.showPlayerList((CommandSourceStack)context.getSource())));
    }

    private static int showPlayerList(CommandSourceStack source) {
        PlayerList playerList = source.getServer().getPlayerList();
        ServerPlayer viewer = source.getPlayer();
        ArrayList onlinePlayers = new ArrayList(playerList.getPlayers());
        long hiddenTotal = onlinePlayers.stream().filter(ListCommand::isHidden).count();
        boolean canSeeHidden = viewer == null || ListCommand.canSeeHidden(viewer);
        List visiblePlayers = onlinePlayers.stream().filter(player -> canSeeHidden || !ListCommand.isHidden(player)).collect(Collectors.toCollection(ArrayList::new));
        if (visiblePlayers.isEmpty()) {
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.list.no_players"), false);
            if (!canSeeHidden && hiddenTotal > 0L) {
                source.sendSuccess(() -> Localization.formatted("commands.foundryx.list.hidden_count", hiddenTotal), false);
            }
            return 0;
        }
        ModConfig config = ModConfig.get();
        ModConfig.ListSettings listSettings = config.list();
        Map<String, Integer> priorityMap = ListCommand.buildPriorityMap(listSettings);
        Map<String, MutableComponent> configuredNames = ListCommand.buildConfiguredNames(listSettings);
        Map<String, String> originalNames = ListCommand.buildConfiguredOriginalNames(listSettings);
        String normalizedDefault = ListCommand.normalizeGroup(listSettings.defaultGroup());
        String defaultGroup = normalizedDefault != null ? normalizedDefault : DEFAULT_GROUP;
        List entries = visiblePlayers.stream().map(player -> ListCommand.createEntry(player, listSettings, defaultGroup)).collect(Collectors.toCollection(ArrayList::new));
        for (Object entry2 : entries) {
            String original = ((PlayerEntry)entry2).originalGroup();
            if (original == null || original.isBlank()) continue;
            originalNames.putIfAbsent(((PlayerEntry)entry2).groupKey(), original);
        }
        LinkedHashMap<String, List> grouped = new LinkedHashMap<String, List>();
        for (PlayerEntry entry3 : entries) {
            grouped.computeIfAbsent(entry3.groupKey(), ignored -> new ArrayList()).add(entry3);
        }
        MutableComponent header = canSeeHidden ? Localization.formatted("commands.foundryx.list.header_with_hidden", entries.size(), onlinePlayers.size(), playerList.getMaxPlayers(), hiddenTotal) : Localization.formatted("commands.foundryx.list.header", entries.size(), onlinePlayers.size(), playerList.getMaxPlayers());
        source.sendSuccess(() -> header, false);
        if (!canSeeHidden && hiddenTotal > 0L) {
            source.sendSuccess(() -> Localization.formatted("commands.foundryx.list.hidden_count", hiddenTotal), false);
        }
        MutableComponent separator = ListCommand.resolveSeparator();
        MutableComponent hiddenSuffix = canSeeHidden ? ListCommand.resolveHiddenSuffix() : null;
        ArrayList sortedGroups = new ArrayList(grouped.entrySet());
        sortedGroups.sort((a, b) -> {
            int priorityB;
            int priorityA = priorityMap.getOrDefault(a.getKey(), priorityMap.size());
            if (priorityA != (priorityB = priorityMap.getOrDefault(b.getKey(), priorityMap.size()).intValue())) {
                return Integer.compare(priorityA, priorityB);
            }
            return ((String)a.getKey()).compareToIgnoreCase((String)b.getKey());
        });
        for (Map.Entry entry2 : sortedGroups) {
            List players = (List)entry2.getValue();
            if (players.isEmpty()) continue;
            players.sort(Comparator.comparing(entry -> entry.displayName().getString(), String.CASE_INSENSITIVE_ORDER));
            List playerNames = players.stream().map(entry -> ListCommand.formatPlayerName(entry, hiddenSuffix)).collect(Collectors.toCollection(ArrayList::new));
            MutableComponent joinedPlayers = ListCommand.joinWithSeparator(playerNames, separator);
            MutableComponent groupLabel = ListCommand.resolveGroupDisplayName((String)entry2.getKey(), originalNames.get(entry2.getKey()), configuredNames);
            MutableComponent countComponent = Component.literal((String)String.valueOf(players.size()));
            MutableComponent line = Localization.formatted("commands.foundryx.list.group_line", groupLabel, countComponent, joinedPlayers);
            source.sendSuccess(() -> line, false);
        }
        return entries.size();
    }

    private static boolean canSeeHidden(ServerPlayer viewer) {
        return FoundryxPermissions.check(viewer, FoundryxPermission.COMMAND_LIST_SEE_HIDDEN) || VanishManager.canSeeVanished(viewer);
    }

    private static PlayerEntry createEntry(ServerPlayer player, ModConfig.ListSettings settings, String defaultGroup) {
        boolean hidden = ListCommand.isHidden(player);
        GroupInfo groupInfo = ListCommand.resolveGroupInfo(player, settings, defaultGroup);
        MutableComponent displayName = ListCommand.buildDisplayName(player);
        return new PlayerEntry(groupInfo.key(), groupInfo.original(), displayName, hidden);
    }

    private static GroupInfo resolveGroupInfo(ServerPlayer player, ModConfig.ListSettings settings, String defaultGroup) {
        String primaryGroup = LuckPermsMetaUtil.getPrimaryGroup(player);
        if (primaryGroup == null || primaryGroup.isBlank()) {
            String fallback = settings.defaultGroup();
            String normalized = ListCommand.normalizeGroup(fallback);
            if (normalized == null) {
                normalized = defaultGroup;
            }
            String original = fallback != null && !fallback.isBlank() ? fallback : DEFAULT_GROUP;
            return new GroupInfo(normalized, original);
        }
        String normalized = ListCommand.normalizeGroup(primaryGroup);
        if (normalized == null) {
            normalized = defaultGroup;
        }
        return new GroupInfo(normalized, primaryGroup);
    }

    private static MutableComponent buildDisplayName(ServerPlayer player) {
        Component parsed;
        MutableComponent display = Component.empty();
        String prefix = LuckPermsMetaUtil.getPrefix(player);
        if (prefix != null && !prefix.isBlank() && (parsed = ChatFormatter.legacyToComponent(prefix)) != null) {
            display.append((Component)parsed.copy());
            if (!ListCommand.hasTrailingWhitespace(prefix)) {
                display.append((Component)SPACE.copy());
            }
        }
        MutableComponent baseName = ChatFormatter.sanitizeDisplayName(player).copy();
        display.append((Component)baseName);
        if (display.getString().isEmpty()) {
            display.append((Component)player.getName().copy());
        }
        return display;
    }

    private static MutableComponent formatPlayerName(PlayerEntry entry, MutableComponent hiddenSuffix) {
        MutableComponent name = entry.displayName().copy();
        if (entry.hidden() && hiddenSuffix != null) {
            name.append((Component)hiddenSuffix.copy());
        }
        return name;
    }

    private static MutableComponent joinWithSeparator(List<MutableComponent> components, MutableComponent separator) {
        MutableComponent result = Component.empty();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                result.append((Component)separator.copy());
            }
            result.append((Component)components.get(i).copy());
        }
        return result;
    }

    private static MutableComponent resolveGroupDisplayName(String groupKey, String originalGroup, Map<String, MutableComponent> configuredNames) {
        String fallback;
        MutableComponent configured = configuredNames.get(groupKey);
        if (configured != null) {
            return configured.copy();
        }
        String string = fallback = originalGroup != null && !originalGroup.isBlank() ? originalGroup : groupKey;
        if (fallback == null || fallback.isBlank()) {
            fallback = DEFAULT_GROUP;
        }
        return Component.literal((String)ListCommand.capitalize(fallback));
    }

    private static MutableComponent resolveSeparator() {
        Component parsed;
        String raw = Localization.raw("commands.foundryx.list.separator");
        if (raw == null || raw.isBlank()) {
            raw = "\u00a77, \u00a7f";
        }
        if ((parsed = ChatFormatter.legacyToComponent(raw)) instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)parsed;
            return mutable.copy();
        }
        if (parsed != null) {
            return parsed.copy();
        }
        return Component.literal((String)raw);
    }

    private static MutableComponent resolveHiddenSuffix() {
        Component parsed;
        String raw = Localization.raw("commands.foundryx.list.hidden_suffix");
        if (raw == null || raw.isBlank()) {
            raw = "\u00a77*";
        }
        if ((parsed = ChatFormatter.legacyToComponent(raw)) instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)parsed;
            return mutable.copy();
        }
        if (parsed != null) {
            return parsed.copy();
        }
        return Component.literal((String)raw);
    }

    private static Map<String, Integer> buildPriorityMap(ModConfig.ListSettings settings) {
        HashMap<String, Integer> priority = new HashMap<String, Integer>();
        int index = 0;
        for (String group : settings.groupOrder()) {
            String normalized = ListCommand.normalizeGroup(group);
            if (normalized == null || priority.containsKey(normalized)) continue;
            priority.put(normalized, index++);
        }
        return priority;
    }

    private static Map<String, MutableComponent> buildConfiguredNames(ModConfig.ListSettings settings) {
        HashMap<String, MutableComponent> names = new HashMap<String, MutableComponent>();
        settings.groupDisplayNames().forEach((key, value) -> {
            String normalized = ListCommand.normalizeGroup(key);
            if (normalized == null || value == null || value.isBlank()) {
                return;
            }
            Component parsed = ChatFormatter.legacyToComponent(value);
            if (parsed instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)parsed;
                names.put(normalized, mutable.copy());
            } else if (parsed != null) {
                names.put(normalized, parsed.copy());
            } else {
                names.put(normalized, Component.literal((String)value));
            }
        });
        return names;
    }

    private static Map<String, String> buildConfiguredOriginalNames(ModConfig.ListSettings settings) {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String group : settings.groupOrder()) {
            String normalized = ListCommand.normalizeGroup(group);
            if (normalized == null || group == null || group.isBlank()) continue;
            names.putIfAbsent(normalized, group);
        }
        String defaultGroup = settings.defaultGroup();
        String normalizedDefault = ListCommand.normalizeGroup(defaultGroup);
        if (normalizedDefault != null && defaultGroup != null && !defaultGroup.isBlank()) {
            names.putIfAbsent(normalizedDefault, defaultGroup);
        }
        return names;
    }

    private static boolean isHidden(ServerPlayer player) {
        if (VanishManager.isVanished(player)) {
            return true;
        }
        return player.getTags().contains(HIDDEN_TAG);
    }

    private static boolean hasTrailingWhitespace(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return Character.isWhitespace(value.charAt(value.length() - 1));
    }

    private static String normalizeGroup(String group) {
        if (group == null) {
            return null;
        }
        String trimmed = group.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed.toLowerCase(Locale.ROOT);
    }

    private static String capitalize(String value) {
        if (value == null || value.isEmpty()) {
            return DEFAULT_GROUP.substring(0, 1).toUpperCase(Locale.ROOT) + DEFAULT_GROUP.substring(1);
        }
        if (value.length() == 1) {
            return value.toUpperCase(Locale.ROOT);
        }
        return value.substring(0, 1).toUpperCase(Locale.ROOT) + value.substring(1);
    }

    private record PlayerEntry(String groupKey, String originalGroup, MutableComponent displayName, boolean hidden) {
    }

    private record GroupInfo(String key, String original) {
    }
}

