/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class MailCommand {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm", Locale.ROOT).withZone(ZoneId.systemDefault());

    private MailCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mail").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_MAIL))).executes(MailCommand::list)).then(Commands.literal((String)"clear").executes(MailCommand::clear))).then(Commands.literal((String)"send").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(MailCommand::send))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(MailCommand::send))));
    }

    private static int list(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        List<FoundryxDataStorage.MailMessage> messages = storage.getMail(player.getUUID());
        if (messages.isEmpty()) {
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.empty"));
            return 0;
        }
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.header", messages.size()));
        for (FoundryxDataStorage.MailMessage message : messages) {
            Component body = MailCommand.parseMessage(message.message());
            Component sender = MailCommand.resolveSender(context, message.sender());
            String timestamp = FORMATTER.format(Instant.ofEpochMilli(message.timestamp()));
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.entry", sender, timestamp, body));
        }
        return messages.size();
    }

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        List<FoundryxDataStorage.MailMessage> removed = storage.clearMail(player.getUUID());
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.cleared", removed.size()));
        return removed.size();
    }

    private static int send(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        Component message = MessageArgument.getMessage(context, (String)"message");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        storage.addMail(target.getUUID(), new FoundryxDataStorage.MailMessage(sender.getUUID(), System.currentTimeMillis(), message.getString()));
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.received", sender.getName()));
        sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.mail.sent", target.getName()));
        return 1;
    }

    private static Component parseMessage(String message) {
        if (message == null || message.isEmpty()) {
            return Component.literal((String)"");
        }
        return Component.literal((String)message);
    }

    private static Component resolveSender(CommandContext<CommandSourceStack> context, UUID sender) {
        if (sender == null) {
            return Localization.formatted("commands.foundryx.mail.sender.server");
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(sender);
        if (player != null) {
            return player.getName();
        }
        return Component.literal((String)sender.toString());
    }
}

