/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class MessageCommands {
    private MessageCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        MessageCommands.registerLiteral(dispatcher, "msg");
        MessageCommands.registerLiteral(dispatcher, "tell");
        MessageCommands.registerLiteral(dispatcher, "m");
    }

    private static void registerLiteral(CommandDispatcher<CommandSourceStack> dispatcher, String literal) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_MESSAGE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(MessageCommands::send))));
    }

    private static int send(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        Component message = MessageArgument.getMessage(context, (String)"message");
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.isMuted(sender.getUUID())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.msg.muted"));
            return 0;
        }
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.msg.received", sender.getName(), message));
        sender.sendSystemMessage((Component)Localization.formatted("commands.foundryx.msg.sent", target.getName(), message));
        return 1;
    }
}

