/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class MotdCommand {
    private static final String MOTD_KEY = "commands.foundryx.motd";

    private MotdCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"motd").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_MOTD))).executes(MotdCommand::showMotd));
    }

    private static int showMotd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String motd = Localization.raw(MOTD_KEY);
        if (motd == null || motd.isBlank()) {
            return 0;
        }
        int lines = 0;
        for (String rawLine : motd.split("\r?\n")) {
            Component component;
            String trimmed = rawLine.trim();
            if (trimmed.isEmpty() || (component = ChatFormatter.legacyToComponent(trimmed)) == null || component.getString().isBlank()) continue;
            player.sendSystemMessage(component);
            ++lines;
        }
        return lines;
    }
}

