/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public final class RulesCommand {
    private static final List<String> RULE_LINE_KEYS = List.of("commands.foundryx.rules.line1", "commands.foundryx.rules.line2", "commands.foundryx.rules.line3", "commands.foundryx.rules.line4", "commands.foundryx.rules.line5");

    private RulesCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rules").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_RULES))).executes(RulesCommand::showRules));
    }

    private static int showRules(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.rules.header"), false);
        RULE_LINE_KEYS.forEach(key -> source.sendSuccess(() -> Localization.formatted(key), false));
        return RULE_LINE_KEYS.size() + 1;
    }
}

