/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class SpawnCommand {
    private SpawnCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_SPAWN))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
            Optional<FoundryxDataStorage.TeleportTarget> destination = storage.getSpawn();
            if (destination.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.spawn.missing"));
                return 0;
            }
            FoundryxDataStorage.TeleportTarget target = destination.get();
            ModConfig.TeleportSettings settings = ModConfig.get().teleport();
            int delay = Math.max(0, settings.spawnTeleportDelay());
            boolean cancelOnMove = settings.cancelTeleportOnMove();
            boolean cancelOnDamage = settings.cancelTeleportOnDamage();
            if (delay <= 0) {
                if (TeleportService.teleport(player, target, storage)) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.spawn.teleported"), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
                return 0;
            }
            TeleportDelayManager manager = TeleportDelayManager.get(((CommandSourceStack)context.getSource()).getServer());
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            manager.scheduleTeleport(player, delay, cancelOnMove, cancelOnDamage, teleported -> {
                if (TeleportService.teleport(teleported, target, storage)) {
                    source.sendSuccess(() -> Localization.formatted("commands.foundryx.spawn.teleported"), false);
                } else {
                    source.sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
                }
            }, () -> {});
            return 1;
        }));
    }
}

