/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.managers.TabManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;

public final class TabCommand {
    private TabCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tab").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TAB_RELOAD))).then(Commands.literal((String)"reload").executes(TabCommand::reload)));
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        TabCommand.reload(((CommandSourceStack)context.getSource()).getServer());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.tab.reload"), true);
        return 1;
    }

    public static void reload(MinecraftServer server) {
        if (server != null) {
            TabManager.updateAll(server);
        }
    }
}

