/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;

public final class TimeCommand {
    private TimeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TIME))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"day").executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, 1000)))).then(Commands.literal((String)"noon").executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, 6000)))).then(Commands.literal((String)"night").executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, 13000)))).then(Commands.literal((String)"midnight").executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, 18000)))).then(Commands.argument((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"daytime").executes(context -> TimeCommand.queryDayTime((CommandContext<CommandSourceStack>)context, QueryType.DAYTIME)))).then(Commands.literal((String)"gametime").executes(context -> TimeCommand.queryDayTime((CommandContext<CommandSourceStack>)context, QueryType.GAMETIME)))).then(Commands.literal((String)"day").executes(context -> TimeCommand.queryDayTime((CommandContext<CommandSourceStack>)context, QueryType.DAY)))));
    }

    private static int setTime(CommandContext<CommandSourceStack> context, int time) {
        for (ServerLevel level : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
            level.setDayTime((long)time);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.time.set", time), true);
        return time;
    }

    private static int addTime(CommandContext<CommandSourceStack> context, int amount) {
        for (ServerLevel level : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
            level.setDayTime(level.getDayTime() + (long)amount);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.time.add", amount), true);
        return amount;
    }

    private static int queryDayTime(CommandContext<CommandSourceStack> context, QueryType type) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        long value = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> level.getGameTime();
            case 0 -> level.getDayTime() % 24000L;
            case 2 -> level.getDayTime() / 24000L;
        };
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted(type.translationKey, value), false);
        return (int)value;
    }

    private static enum QueryType {
        DAYTIME("commands.foundryx.time.query.daytime"),
        GAMETIME("commands.foundryx.time.query.gametime"),
        DAY("commands.foundryx.time.query.day");

        private final String translationKey;

        private QueryType(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

