/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.server;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;

public final class WeatherCommand {
    private WeatherCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"weather").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_WEATHER))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, 6000, WeatherType.CLEAR))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"duration") * 20, WeatherType.CLEAR))))).then(((LiteralArgumentBuilder)Commands.literal((String)"rain").executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, 6000, WeatherType.RAIN))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"duration") * 20, WeatherType.RAIN))))).then(((LiteralArgumentBuilder)Commands.literal((String)"thunder").executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, 6000, WeatherType.THUNDER))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"duration") * 20, WeatherType.THUNDER)))));
    }

    private static int setWeather(CommandContext<CommandSourceStack> context, int durationTicks, WeatherType type) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        switch (type.ordinal()) {
            case 0: {
                level.setWeatherParameters(durationTicks, 0, false, false);
                break;
            }
            case 1: {
                level.setWeatherParameters(0, durationTicks, true, false);
                break;
            }
            case 2: {
                level.setWeatherParameters(0, durationTicks, true, true);
            }
        }
        MutableComponent weather = Localization.formatted(type.translationKey);
        MutableComponent message = Localization.formatted("commands.foundryx.weather.changed", weather);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> WeatherCommand.lambda$setWeather$7((Component)message), true);
        return durationTicks;
    }

    private static /* synthetic */ Component lambda$setWeather$7(Component message) {
        return message;
    }

    private static enum WeatherType {
        CLEAR("commands.foundryx.weather.clear"),
        RAIN("commands.foundryx.weather.rain"),
        THUNDER("commands.foundryx.weather.thunder");

        private final String translationKey;

        private WeatherType(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

