/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.teleport;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class BackCommand {
    private BackCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BACK))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
            Optional<FoundryxDataStorage.TeleportTarget> target = storage.consumeBack(player.getUUID());
            if (target.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.back.missing"));
                return 0;
            }
            FoundryxDataStorage.TeleportTarget teleportTarget = target.get();
            ModConfig.TeleportSettings settings = ModConfig.get().teleport();
            int delay = Math.max(0, settings.backTeleportDelay());
            boolean cancelOnMove = settings.cancelTeleportOnMove();
            boolean cancelOnDamage = settings.cancelTeleportOnDamage();
            Runnable restoreBack = () -> storage.rememberBack(player.getUUID(), teleportTarget);
            if (delay <= 0) {
                if (TeleportService.teleport(player, teleportTarget, storage)) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.back.teleported"), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
                restoreBack.run();
                return 0;
            }
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            TeleportDelayManager manager = TeleportDelayManager.get(source.getServer());
            manager.scheduleTeleport(player, delay, cancelOnMove, cancelOnDamage, teleported -> {
                if (TeleportService.teleport(teleported, teleportTarget, storage)) {
                    source.sendSuccess(() -> Localization.formatted("commands.foundryx.back.teleported"), false);
                } else {
                    source.sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
                    restoreBack.run();
                }
            }, restoreBack);
            return 1;
        }));
    }
}

