/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.teleport;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public final class TeleportCommands {
    private static final SimpleCommandExceptionType REQUIRES_PLAYER = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.tp.player_required"));

    private TeleportCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TELEPORT))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> TeleportCommands.teleportSelf((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))).then(Commands.argument((String)"destination", (ArgumentType)EntityArgument.player()).executes(context -> TeleportCommands.teleportOther((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), EntityArgument.getPlayer((CommandContext)context, (String)"destination"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tphere").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TELEPORT_HERE))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> TeleportCommands.teleportHere((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tppos").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TELEPORT_POS))).then(Commands.argument((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(TeleportCommands::teleportPos)))));
    }

    private static int teleportSelf(CommandContext<CommandSourceStack> context, ServerPlayer destination) throws CommandSyntaxException {
        ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return TeleportCommands.teleportToPlayer(context, sourcePlayer, destination);
    }

    private static int teleportOther(CommandContext<CommandSourceStack> context, ServerPlayer target, ServerPlayer destination) {
        return TeleportCommands.teleportToPlayer(context, target, destination);
    }

    private static int teleportHere(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (sourcePlayer == null) {
            throw REQUIRES_PLAYER.create();
        }
        return TeleportCommands.teleportToPlayer(context, target, sourcePlayer);
    }

    private static int teleportToPlayer(CommandContext<CommandSourceStack> context, ServerPlayer target, ServerPlayer destination) {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        FoundryxDataStorage.LocationSnapshot snapshot = FoundryxDataStorage.LocationSnapshot.from(destination);
        snapshot.toTeleportTarget().ifPresent(targetPoint -> TeleportService.teleport(target, targetPoint, storage));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.tp.success", target.getName(), destination.getName()), true);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tp.notice", destination.getName()));
        return 1;
    }

    private static int teleportPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FoundryxDataStorage storage;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel level = player.level();
        double x = DoubleArgumentType.getDouble(context, (String)"x");
        double y = DoubleArgumentType.getDouble(context, (String)"y");
        double z = DoubleArgumentType.getDouble(context, (String)"z");
        FoundryxDataStorage.TeleportTarget target = new FoundryxDataStorage.TeleportTarget((ResourceKey<Level>)level.dimension(), x, y, z, player.getYRot(), player.getXRot());
        if (TeleportService.teleport(player, target, storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer()))) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.tppos.success", x, y, z), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
        return 0;
    }
}

