/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.teleport;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import com.foundryx.teleport.TeleportRequestManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class TeleportRequestCommands {
    private static final long REQUEST_DURATION = 120000L;

    private TeleportRequestCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpa").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TPA))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> TeleportRequestCommands.requestTeleport((CommandContext<CommandSourceStack>)context, false))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"call").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TPA))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> TeleportRequestCommands.requestTeleport((CommandContext<CommandSourceStack>)context, false))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaccept").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TP_ACCEPT))).executes(TeleportRequestCommands::accept));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpdeny").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_TP_DENY))).executes(TeleportRequestCommands::deny));
    }

    private static int requestTeleport(CommandContext<CommandSourceStack> context, boolean here) throws CommandSyntaxException {
        ServerPlayer requester = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        if (requester.getUUID().equals(target.getUUID())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.tpa.self"));
            return 0;
        }
        TeleportRequestManager manager = TeleportRequestManager.get(((CommandSourceStack)context.getSource()).getServer());
        manager.createRequest(requester, target, here, 120000L);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpa.request", requester.getName()));
        requester.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpa.sent", target.getName()));
        return 1;
    }

    private static int accept(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer teleportedPlayer;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        TeleportRequestManager manager = TeleportRequestManager.get(((CommandSourceStack)context.getSource()).getServer());
        Optional<TeleportRequestManager.TeleportRequest> request = manager.consumeRequest(player.getUUID());
        if (request.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.tpaccept.none"));
            return 0;
        }
        ModConfig config = ModConfig.get();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        int delay = Math.max(0, config.tpa().tpaTeleportDelay());
        boolean cancelOnMove = config.teleport().cancelTeleportOnMove();
        boolean cancelOnDamage = config.teleport().cancelTeleportOnDamage();
        TeleportRequestManager.TeleportRequest teleportRequest = request.get();
        if (delay <= 0) {
            return TeleportRequestCommands.completeTeleport((CommandSourceStack)context.getSource(), teleportRequest, storage, player) ? 1 : 0;
        }
        ServerPlayer serverPlayer = teleportedPlayer = teleportRequest.here() ? player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(teleportRequest.requester());
        if (teleportedPlayer == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.tpaccept.failed"));
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TeleportDelayManager delayManager = TeleportDelayManager.get(source.getServer());
        delayManager.scheduleTeleport(teleportedPlayer, delay, cancelOnMove, cancelOnDamage, ignored -> TeleportRequestCommands.completeTeleport(source, teleportRequest, storage, player), () -> {});
        return 1;
    }

    private static int deny(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        TeleportRequestManager manager = TeleportRequestManager.get(((CommandSourceStack)context.getSource()).getServer());
        Optional<TeleportRequestManager.TeleportRequest> request = manager.consumeRequest(player.getUUID());
        if (request.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.tpdeny.none"));
            return 0;
        }
        ServerPlayer requester = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(request.get().requester());
        if (requester != null) {
            requester.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpdeny.notice", player.getName()));
        }
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpdeny.sent"));
        return 1;
    }

    private static boolean completeTeleport(CommandSourceStack source, TeleportRequestManager.TeleportRequest request, FoundryxDataStorage storage, ServerPlayer acceptor) {
        if (!request.teleport(source.getServer(), storage)) {
            source.sendFailure((Component)Localization.formatted("commands.foundryx.tpaccept.failed"));
            return false;
        }
        ServerPlayer requester = source.getServer().getPlayerList().getPlayer(request.requester());
        if (requester != null) {
            requester.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpaccept.accepted", acceptor.getName()));
        }
        acceptor.sendSystemMessage((Component)Localization.formatted("commands.foundryx.tpaccept.notice"));
        return true;
    }
}

