/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.util;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class CommandUtil {
    private static final DynamicCommandExceptionType TARGET_EXEMPT = new DynamicCommandExceptionType(name -> Localization.formatted("commands.foundryx.target.exempt", name));

    private CommandUtil() {
    }

    public static void ensureCanAffect(CommandSourceStack source, ServerPlayer target, FoundryxPermission exemptPermission, FoundryxPermission forcePermission) throws CommandSyntaxException {
        if (CommandUtil.isSameEntity(source, target)) {
            return;
        }
        if (!FoundryxPermissions.check(target, exemptPermission)) {
            return;
        }
        if (FoundryxPermissions.check(source, forcePermission)) {
            return;
        }
        throw TARGET_EXEMPT.create((Object)target.getName());
    }

    public static void notify(CommandSourceStack source, Component message, FoundryxPermission notifyPermission) {
        source.getServer().getPlayerList().getPlayers().stream().filter(player -> FoundryxPermissions.check(player, notifyPermission)).forEach(player -> player.sendSystemMessage((Component)message.copy()));
    }

    private static boolean isSameEntity(CommandSourceStack source, ServerPlayer target) {
        ServerPlayer executor;
        Entity entity = source.getEntity();
        return entity instanceof ServerPlayer && (executor = (ServerPlayer)entity).getUUID().equals(target.getUUID());
    }
}

