/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Locale;

public final class DurationParser {
    private DurationParser() {
    }

    public static long parse(String input, DynamicCommandExceptionType invalidDuration) throws CommandSyntaxException {
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            throw invalidDuration.create((Object)input);
        }
        String normalised = trimmed.replace(" ", "").toLowerCase(Locale.ROOT);
        long totalSeconds = 0L;
        int index = 0;
        while (index < normalised.length()) {
            long value;
            int start = index;
            while (index < normalised.length() && Character.isDigit(normalised.charAt(index))) {
                ++index;
            }
            if (start == index) {
                throw invalidDuration.create((Object)input);
            }
            try {
                value = Long.parseLong(normalised.substring(start, index));
            }
            catch (NumberFormatException exception) {
                throw invalidDuration.create((Object)input);
            }
            long multiplier = 1L;
            if (index < normalised.length()) {
                char unit = normalised.charAt(index++);
                multiplier = switch (unit) {
                    case 's' -> 1L;
                    case 'm' -> 60L;
                    case 'h' -> 3600L;
                    case 'd' -> 86400L;
                    case 'w' -> 604800L;
                    default -> throw invalidDuration.create((Object)input);
                };
            }
            try {
                totalSeconds = Math.addExact(totalSeconds, Math.multiplyExact(value, multiplier));
            }
            catch (ArithmeticException exception) {
                throw invalidDuration.create((Object)input);
            }
        }
        if (totalSeconds <= 0L) {
            throw invalidDuration.create((Object)input);
        }
        return totalSeconds;
    }
}

