/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.warp;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import com.foundryx.teleport.TeleportService;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

final class WarpCommandUtil {
    private static final SuggestionProvider<CommandSourceStack> WARP_SUGGESTIONS = (context, builder) -> {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        return SharedSuggestionProvider.suggest(storage.getWarpNames(), (SuggestionsBuilder)builder);
    };

    private WarpCommandUtil() {
    }

    static SuggestionProvider<CommandSourceStack> warpSuggestions() {
        return WARP_SUGGESTIONS;
    }

    static int setWarp(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        storage.setWarp(name, player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.setwarp.saved", name), true);
        return 1;
    }

    static int teleportWarp(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        Optional<FoundryxDataStorage.TeleportTarget> destination = storage.getWarp(name);
        if (destination.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.warp.missing", name));
            return 0;
        }
        FoundryxDataStorage.TeleportTarget target = destination.get();
        ModConfig config = ModConfig.get();
        int delay = Math.max(0, config.tpa().warpTeleportDelay());
        boolean cancelOnMove = config.teleport().cancelTeleportOnMove();
        boolean cancelOnDamage = config.teleport().cancelTeleportOnDamage();
        if (delay <= 0) {
            if (TeleportService.teleport(player, target, storage)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.warp.teleported", name), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TeleportDelayManager manager = TeleportDelayManager.get(source.getServer());
        manager.scheduleTeleport(player, delay, cancelOnMove, cancelOnDamage, teleported -> {
            if (TeleportService.teleport(teleported, target, storage)) {
                source.sendSuccess(() -> Localization.formatted("commands.foundryx.warp.teleported", name), false);
            } else {
                source.sendFailure((Component)Localization.formatted("commands.foundryx.teleport.failed"));
            }
        }, () -> {});
        return 1;
    }

    static int deleteWarp(CommandContext<CommandSourceStack> context, String name) {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        if (storage.deleteWarp(name)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.delwarp.removed", name), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Localization.formatted("commands.foundryx.warp.missing", name));
        return 0;
    }

    static int listWarps(CommandContext<CommandSourceStack> context) {
        FoundryxDataStorage storage = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer());
        Collection<String> warps = storage.getWarpNames();
        if (warps.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.warps.empty"), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.warps.list", String.join((CharSequence)", ", warps)), false);
        }
        return warps.size();
    }
}

