/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.config;

import com.foundryx.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public final class ModConfig {
    private static final Path CONFIG_PATH = Path.of("config", "foundryx.toml");
    private static final int DEFAULT_NAME_COLOR_VALUE = 0x55FF55;
    private static final int DEFAULT_MESSAGE_COLOR_VALUE = 0xFFFFFF;
    private static volatile ModConfig instance = new ModConfig();
    private int defaultNameColor = 0x55FF55;
    private int defaultMessageColor = 0xFFFFFF;
    private String messageSeparator = ": ";
    private final TeleportSettings teleport = new TeleportSettings();
    private final TpaSettings tpa = new TpaSettings();
    private final LanguageSettings language = new LanguageSettings();
    private final TabSettings tab = new TabSettings();
    private final ListSettings list = new ListSettings();
    private final AfkSettings afk = new AfkSettings();
    private final NearSettings near = new NearSettings();
    private final EconomySettings economy = new EconomySettings();
    private final StorageSettings storage = new StorageSettings();

    private ModConfig() {
    }

    public static ModConfig get() {
        return instance;
    }

    public static void load() {
        ModConfig config = new ModConfig();
        config.read();
        config.write();
        instance = config;
        Constants.LOG.debug("Loaded configuration from {}", (Object)CONFIG_PATH.toAbsolutePath());
    }

    public int defaultNameColor() {
        return this.defaultNameColor;
    }

    public int defaultMessageColor() {
        return this.defaultMessageColor;
    }

    public String messageSeparator() {
        return this.messageSeparator;
    }

    public TeleportSettings teleport() {
        return this.teleport;
    }

    public TpaSettings tpa() {
        return this.tpa;
    }

    public LanguageSettings language() {
        return this.language;
    }

    public TabSettings tab() {
        return this.tab;
    }

    public ListSettings list() {
        return this.list;
    }

    public AfkSettings afk() {
        return this.afk;
    }

    public NearSettings near() {
        return this.near;
    }

    public StorageSettings storage() {
        return this.storage;
    }

    public EconomySettings economy() {
        return this.economy;
    }

    private void read() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            TomlParseResult result = Toml.parse((Reader)reader);
            if (result.hasErrors()) {
                result.errors().forEach(error -> Constants.LOG.error("Config parse error: {}", (Throwable)error));
            }
            this.defaultNameColor = ModConfig.parseColor(result.getString("DEFAULT_NAME_COLOR"), 0x55FF55);
            this.defaultMessageColor = ModConfig.parseColor(result.getString("DEFAULT_MESSAGE_COLOR"), 0xFFFFFF);
            this.messageSeparator = ModConfig.readString((TomlTable)result, "MESSAGE_SEPARATOR", this.messageSeparator);
            this.teleport.load(result.getTable("teleport"));
            this.tpa.load(result.getTable("tpa"));
            this.language.load(result.getTable("language"));
            this.tab.load(result.getTable("tab"));
            this.list.load(result.getTable("list"));
            this.afk.load(result.getTable("afk"));
            this.near.load(result.getTable("near"));
            this.economy.load(result.getTable("economy"));
            this.storage.load(result.getTable("storage"));
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read configuration file {}", (Object)CONFIG_PATH.toAbsolutePath(), (Object)exception);
        }
    }

    private void write() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to create configuration directory {}", (Object)CONFIG_PATH.getParent(), (Object)exception);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            writer.write(String.format(Locale.ROOT, "DEFAULT_NAME_COLOR = \"%s\"%n", ModConfig.formatColor(this.defaultNameColor)));
            writer.write(String.format(Locale.ROOT, "DEFAULT_MESSAGE_COLOR = \"%s\"%n", ModConfig.formatColor(this.defaultMessageColor)));
            writer.write(String.format(Locale.ROOT, "MESSAGE_SEPARATOR = \"%s\"%n%n", ModConfig.escapeTomlString(this.messageSeparator)));
            writer.write("[teleport]\n");
            writer.write("\t# Home teleport delay (seconds)\n");
            writer.write("\t#Range: 0 ~ 60\n");
            writer.write(String.format(Locale.ROOT, "\thomeTeleportDelay = %d%n", this.teleport.homeTeleportDelay));
            writer.write("\t# Cancel teleport on movement\n");
            writer.write(String.format(Locale.ROOT, "\tcancelTeleportOnMove = %s%n", this.teleport.cancelTeleportOnMove));
            writer.write("\t# Cancel teleport on damage\n");
            writer.write(String.format(Locale.ROOT, "\tcancelTeleportOnDamage = %s%n", this.teleport.cancelTeleportOnDamage));
            writer.write("\t# Spawn teleport delay (seconds)\n");
            writer.write("\t#Range: 0 ~ 60\n");
            writer.write(String.format(Locale.ROOT, "\tspawnTeleportDelay = %d%n", this.teleport.spawnTeleportDelay));
            writer.write("\t# /back teleport delay (seconds)\n");
            writer.write("\t#Range: 0 ~ 60\n");
            writer.write(String.format(Locale.ROOT, "\tbackTeleportDelay = %d%n%n", this.teleport.backTeleportDelay));
            writer.write("[tpa]\n");
            writer.write("\t# TPA delay (seconds)\n");
            writer.write("\t#Range: 0 ~ 60\n");
            writer.write(String.format(Locale.ROOT, "\ttpaTeleportDelay = %d%n", this.tpa.tpaTeleportDelay));
            writer.write("\t# Warp teleport delay (seconds)\n");
            writer.write("\t#Range: 0 ~ 60\n");
            writer.write(String.format(Locale.ROOT, "\twarpTeleportDelay = %d%n%n", this.tpa.warpTeleportDelay));
            writer.write("[language]\n");
            writer.write("\t# Language of mod messages (en_us, ru_ru)\n");
            writer.write(String.format(Locale.ROOT, "\tlanguage = \"%s\"%n%n", ModConfig.escapeTomlString(this.language.language)));
            writer.write("[tab]\n");
            writer.write("\t# TAB list auto-refresh interval in seconds (0 = disabled)\n");
            writer.write("\t#Range: 0 ~ 3600\n");
            writer.write(String.format(Locale.ROOT, "\ttabUpdateInterval = %d%n%n", this.tab.tabUpdateInterval));
            writer.write("[list]\n");
            writer.write("\t# Display order of groups in /list (highest to lowest)\n");
            writer.write(String.format(Locale.ROOT, "\tgroupOrder = %s%n", ModConfig.formatStringList(this.list.groupOrder)));
            writer.write("\t# Display names for groups (format: group:Name)\n");
            writer.write(String.format(Locale.ROOT, "\tgroupDisplayNames = %s%n%n", ModConfig.formatStringList(this.list.displayNameEntries())));
            writer.write("[afk]\n");
            writer.write("\t# Minutes of inactivity before a player is considered AFK\n");
            writer.write("\t#Range: 1 ~ 120\n");
            writer.write(String.format(Locale.ROOT, "\ttimeoutMinutes = %d%n", this.afk.timeoutMinutes));
            writer.write("\t# Kick players after being AFK too long\n");
            writer.write(String.format(Locale.ROOT, "\tkickEnabled = %s%n", this.afk.kickEnabled));
            writer.write("\t# Minutes before an AFK player is kicked (if kickEnabled = true)\n");
            writer.write("\t#Range: 1 ~ 240\n");
            writer.write(String.format(Locale.ROOT, "\tkickAfterMinutes = %d%n%n", this.afk.kickAfterMinutes));
            writer.write("[near]\n");
            writer.write("\t# Radius to search for nearby players (blocks)\n");
            writer.write("\t#Range: 1 ~ 1000\n");
            writer.write(String.format(Locale.ROOT, "\tradius = %d%n", this.near.radius()));
            writer.write("\n");
            writer.write("[economy]\n");
            writer.write("\t# Symbol prefixed to currency amounts in economy messages\n");
            writer.write(String.format(Locale.ROOT, "\tcurrencySymbol = \"%s\"%n%n", ModConfig.escapeTomlString(this.economy.currencySymbol())));
            writer.write("[storage]\n");
            writer.write("\t# Persist data to an external database instead of local files\n");
            writer.write(String.format(Locale.ROOT, "\tuseDatabase = %s%n%n", this.storage.useDatabase));
            writer.write("[storage.database]\n");
            writer.write("\t# Database dialect to use (postgresql, mysql, mariadb, h2)\n");
            writer.write(String.format(Locale.ROOT, "\ttype = \"%s\"%n", this.storage.database.type));
            writer.write("\t# Optional explicit JDBC URL (overrides other database settings)\n");
            writer.write(String.format(Locale.ROOT, "\turl = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.url)));
            writer.write("[storage.database.sql]\n");
            writer.write("\t# Database hostname for PostgreSQL/MySQL/MariaDB\n");
            writer.write(String.format(Locale.ROOT, "\thost = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.sql().host())));
            writer.write("\t# Database port for PostgreSQL/MySQL/MariaDB\n");
            writer.write(String.format(Locale.ROOT, "\tport = %d%n", this.storage.database.sql().port()));
            writer.write("\t# Database/schema name for PostgreSQL/MySQL/MariaDB\n");
            writer.write(String.format(Locale.ROOT, "\tdatabase = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.sql().database())));
            writer.write("\t# Database username for PostgreSQL/MySQL/MariaDB\n");
            writer.write(String.format(Locale.ROOT, "\tusername = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.sql().username())));
            writer.write("\t# Database password for PostgreSQL/MySQL/MariaDB\n");
            writer.write(String.format(Locale.ROOT, "\tpassword = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.sql().password())));
            writer.write("\t# Additional JDBC properties appended to SQL connection URLs\n");
            writer.write(String.format(Locale.ROOT, "\tproperties = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.sql().properties())));
            writer.write("[storage.database.h2]\n");
            writer.write("\t# Relative or absolute path to the H2 database file\n");
            writer.write(String.format(Locale.ROOT, "\tfile = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.h2().file())));
            writer.write("\t# Additional properties appended to the H2 JDBC URL\n");
            writer.write(String.format(Locale.ROOT, "\tproperties = \"%s\"%n", ModConfig.escapeTomlString(this.storage.database.h2().properties())));
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to save configuration file {}", (Object)CONFIG_PATH.toAbsolutePath(), (Object)exception);
        }
    }

    private static int parseColor(String value, int fallback) {
        if (value == null || value.isBlank()) {
            return fallback;
        }
        String processed = value.trim();
        if (processed.startsWith("#")) {
            processed = processed.substring(1);
        }
        if (processed.startsWith("0x") || processed.startsWith("0X")) {
            processed = processed.substring(2);
        }
        try {
            int parsed = Integer.parseInt(processed, 16);
            if (parsed < 0) {
                return fallback;
            }
            return parsed & 0xFFFFFF;
        }
        catch (NumberFormatException ignored) {
            return fallback;
        }
    }

    private static String readString(TomlTable table, String key, String fallback) {
        if (table == null) {
            return fallback;
        }
        String value = table.getString(key);
        return value != null ? value : fallback;
    }

    private static String formatColor(int color) {
        return String.format(Locale.ROOT, "#%06X", color & 0xFFFFFF);
    }

    private static String escapeTomlString(String value) {
        String processed = value == null ? "" : value;
        return processed.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String formatStringList(List<String> values) {
        return values.stream().map(value -> String.format(Locale.ROOT, "\"%s\"", ModConfig.escapeTomlString(value))).collect(Collectors.joining(", ", "[", "]"));
    }

    private static int readBoundedInt(TomlTable table, String key, int min, int max, int fallback) {
        int coerced;
        Long value = table.getLong(key);
        if (value == null) {
            return fallback;
        }
        try {
            coerced = Math.toIntExact(value);
        }
        catch (ArithmeticException exception) {
            return fallback;
        }
        if (coerced < min || coerced > max) {
            return fallback;
        }
        return coerced;
    }

    private static int readInt(TomlTable table, String key, int fallback) {
        if (table == null) {
            return fallback;
        }
        Long value = table.getLong(key);
        if (value == null) {
            return fallback;
        }
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException exception) {
            return fallback;
        }
    }

    private static boolean readBoolean(TomlTable table, String key, boolean fallback) {
        Boolean value = table.getBoolean(key);
        return value != null ? value : fallback;
    }

    private static List<String> readStringList(TomlArray array) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            String stringValue;
            Object raw = array.get(i);
            if (!(raw instanceof String) || (stringValue = (String)raw).isBlank()) continue;
            values.add(stringValue.trim());
        }
        return values;
    }

    public static final class TeleportSettings {
        private int homeTeleportDelay = 5;
        private boolean cancelTeleportOnMove = true;
        private boolean cancelTeleportOnDamage = true;
        private int spawnTeleportDelay = 5;
        private int backTeleportDelay = 5;

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            this.homeTeleportDelay = ModConfig.readBoundedInt(table, "homeTeleportDelay", 0, 60, this.homeTeleportDelay);
            this.cancelTeleportOnMove = ModConfig.readBoolean(table, "cancelTeleportOnMove", this.cancelTeleportOnMove);
            this.cancelTeleportOnDamage = ModConfig.readBoolean(table, "cancelTeleportOnDamage", this.cancelTeleportOnDamage);
            this.spawnTeleportDelay = ModConfig.readBoundedInt(table, "spawnTeleportDelay", 0, 60, this.spawnTeleportDelay);
            this.backTeleportDelay = ModConfig.readBoundedInt(table, "backTeleportDelay", 0, 60, this.backTeleportDelay);
        }

        public int homeTeleportDelay() {
            return this.homeTeleportDelay;
        }

        public boolean cancelTeleportOnMove() {
            return this.cancelTeleportOnMove;
        }

        public boolean cancelTeleportOnDamage() {
            return this.cancelTeleportOnDamage;
        }

        public int spawnTeleportDelay() {
            return this.spawnTeleportDelay;
        }

        public int backTeleportDelay() {
            return this.backTeleportDelay;
        }
    }

    public static final class TpaSettings {
        private int tpaTeleportDelay = 3;
        private int warpTeleportDelay = 5;

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            this.tpaTeleportDelay = ModConfig.readBoundedInt(table, "tpaTeleportDelay", 0, 60, this.tpaTeleportDelay);
            this.warpTeleportDelay = ModConfig.readBoundedInt(table, "warpTeleportDelay", 0, 60, this.warpTeleportDelay);
        }

        public int tpaTeleportDelay() {
            return this.tpaTeleportDelay;
        }

        public int warpTeleportDelay() {
            return this.warpTeleportDelay;
        }
    }

    public static final class LanguageSettings {
        private String language = "en_us";

        private void load(TomlTable table) {
            this.language = ModConfig.readString(table, "language", this.language).toLowerCase(Locale.ROOT);
        }

        public String language() {
            return this.language;
        }
    }

    public static final class TabSettings {
        private int tabUpdateInterval = 10;

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            this.tabUpdateInterval = ModConfig.readBoundedInt(table, "tabUpdateInterval", 0, 3600, this.tabUpdateInterval);
        }

        public int tabUpdateInterval() {
            return this.tabUpdateInterval;
        }
    }

    public static final class ListSettings {
        private List<String> groupOrder = new ArrayList<String>(List.of("admin", "moderator", "helper", "vip", "default"));
        private LinkedHashMap<String, String> groupDisplayNames = new LinkedHashMap();

        private ListSettings() {
            this.groupDisplayNames.put("admin", "\u00a7cAdmins");
            this.groupDisplayNames.put("moderator", "\u00a7bModerators");
            this.groupDisplayNames.put("helper", "\u00a79Helpers");
            this.groupDisplayNames.put("vip", "\u00a7aVIP");
            this.groupDisplayNames.put("default", "\u00a77Players");
        }

        private void load(TomlTable table) {
            TomlArray displayArray;
            List<String> parsedOrder;
            if (table == null) {
                return;
            }
            TomlArray orderArray = table.getArray("groupOrder");
            if (orderArray != null && !(parsedOrder = ModConfig.readStringList(orderArray)).isEmpty()) {
                this.groupOrder = new ArrayList<String>(parsedOrder);
            }
            if ((displayArray = table.getArray("groupDisplayNames")) != null) {
                LinkedHashMap<String, String> parsedDisplays = new LinkedHashMap<String, String>();
                for (String entry : ModConfig.readStringList(displayArray)) {
                    int separatorIndex = entry.indexOf(58);
                    if (separatorIndex <= 0) continue;
                    String key = entry.substring(0, separatorIndex).trim();
                    String value = entry.substring(separatorIndex + 1).trim();
                    if (key.isEmpty() || value.isEmpty()) continue;
                    parsedDisplays.put(key, value);
                }
                if (!parsedDisplays.isEmpty()) {
                    this.groupDisplayNames = parsedDisplays;
                }
            }
        }

        public List<String> groupOrder() {
            return Collections.unmodifiableList(this.groupOrder);
        }

        public Map<String, String> groupDisplayNames() {
            return Collections.unmodifiableMap(this.groupDisplayNames);
        }

        public List<String> displayNameEntries() {
            return this.groupDisplayNames.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.toCollection(ArrayList::new));
        }

        public String defaultGroup() {
            if (this.groupOrder.contains("default")) {
                return "default";
            }
            if (this.groupOrder.isEmpty()) {
                return "default";
            }
            return this.groupOrder.get(this.groupOrder.size() - 1);
        }
    }

    public static final class AfkSettings {
        private int timeoutMinutes = 5;
        private boolean kickEnabled = false;
        private int kickAfterMinutes = 30;

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            this.timeoutMinutes = ModConfig.readBoundedInt(table, "timeoutMinutes", 1, 120, this.timeoutMinutes);
            this.kickEnabled = ModConfig.readBoolean(table, "kickEnabled", this.kickEnabled);
            this.kickAfterMinutes = ModConfig.readBoundedInt(table, "kickAfterMinutes", 1, 240, this.kickAfterMinutes);
        }

        public int timeoutMinutes() {
            return this.timeoutMinutes;
        }

        public boolean kickEnabled() {
            return this.kickEnabled;
        }

        public int kickAfterMinutes() {
            return this.kickAfterMinutes;
        }
    }

    public static final class NearSettings {
        private int radius = 100;

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            this.radius = ModConfig.readBoundedInt(table, "radius", 1, 1000, this.radius);
        }

        public int radius() {
            return this.radius;
        }
    }

    public static final class EconomySettings {
        private String currencySymbol = "$";

        public String currencySymbol() {
            return this.currencySymbol;
        }

        private void load(TomlTable table) {
            if (table == null) {
                return;
            }
            String symbol = ModConfig.readString(table, "currencySymbol", this.currencySymbol);
            if (symbol != null) {
                this.currencySymbol = symbol;
            }
        }
    }

    public static final class StorageSettings {
        private boolean useDatabase = false;
        private final DatabaseSettings database = new DatabaseSettings();

        public boolean useDatabase() {
            return this.useDatabase;
        }

        public DatabaseSettings database() {
            return this.database;
        }

        private void load(TomlTable table) {
            Object rawDatabase;
            if (table == null) {
                return;
            }
            this.useDatabase = ModConfig.readBoolean(table, "useDatabase", this.useDatabase);
            TomlTable databaseSection = null;
            Object object = rawDatabase = table.get("database");
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TomlTable.class, CharSequence.class}, (Object)object, n)) {
                case 0: {
                    TomlTable nestedTable;
                    databaseSection = nestedTable = (TomlTable)object;
                    break;
                }
                case -1: {
                    databaseSection = table.getTable("database");
                    break;
                }
                case 1: {
                    CharSequence legacyValue = (CharSequence)object;
                    this.database.loadLegacyString(legacyValue.toString(), table);
                    return;
                }
                default: {
                    Constants.LOG.warn("Unsupported 'storage.database' value of type '{}' - expected a table or string", (Object)rawDatabase.getClass().getSimpleName());
                    return;
                }
            }
            this.database.load(databaseSection, table);
        }
    }

    public static final class DatabaseSettings {
        private String type = "h2";
        private String url = "";
        private final SqlSettings sql = new SqlSettings();
        private final H2Settings h2 = new H2Settings();

        public String type() {
            return this.type;
        }

        public String url() {
            return this.url;
        }

        public SqlSettings sql() {
            return this.sql;
        }

        public H2Settings h2() {
            return this.h2;
        }

        public String host() {
            return this.sql.host;
        }

        public int port() {
            return this.sql.port;
        }

        public String database() {
            return this.sql.database;
        }

        public String username() {
            return this.sql.username;
        }

        public String password() {
            return this.sql.password;
        }

        public String properties() {
            return this.sql.properties;
        }

        private void load(TomlTable table, TomlTable parent) {
            if (table != null) {
                this.read(table);
            } else if (parent != null) {
                this.read(parent);
            }
        }

        private void read(TomlTable table) {
            if (table == null) {
                return;
            }
            this.type = ModConfig.readString(table, "type", this.type);
            this.url = DatabaseSettings.normaliseUrl(ModConfig.readString(table, "url", this.url));
            TomlTable sqlTable = table.getTable("sql");
            this.sql.read(sqlTable, table);
            TomlTable h2Table = table.getTable("h2");
            this.h2.read(h2Table, table);
            Object legacyProperties = table.get("properties");
            if (legacyProperties instanceof String) {
                String legacyString = (String)legacyProperties;
                if (!this.sql.hasExplicitProperties()) {
                    this.sql.setProperties(legacyString);
                }
                if (!this.h2.hasExplicitProperties()) {
                    this.h2.setProperties(legacyString);
                }
            }
        }

        private void loadLegacyString(String value, TomlTable parent) {
            if (value == null) {
                return;
            }
            String trimmed = value.trim();
            if (trimmed.isEmpty()) {
                return;
            }
            Constants.LOG.warn("Detected legacy string for 'storage.database'; interpreting value '{}'", (Object)trimmed);
            if (trimmed.startsWith("jdbc:")) {
                this.url = trimmed;
            } else if (trimmed.contains("://")) {
                this.url = "jdbc:" + trimmed;
            } else {
                this.type = trimmed.toLowerCase(Locale.ROOT);
            }
            if (!this.url.isBlank()) {
                String lowered = this.url.toLowerCase(Locale.ROOT);
                if (lowered.contains(":postgresql://")) {
                    this.type = "postgresql";
                } else if (lowered.contains(":mysql://")) {
                    this.type = "mysql";
                } else if (lowered.contains(":mariadb://")) {
                    this.type = "mariadb";
                } else if (lowered.startsWith("jdbc:h2:")) {
                    this.type = "h2";
                }
            }
            if (parent != null) {
                this.type = ModConfig.readString(parent, "type", this.type);
                this.url = DatabaseSettings.normaliseUrl(ModConfig.readString(parent, "url", this.url));
                this.sql.read(parent.getTable("sql"), parent);
                this.h2.read(parent.getTable("h2"), parent);
                Object legacyProperties = parent.get("properties");
                if (legacyProperties instanceof String) {
                    String legacyString = (String)legacyProperties;
                    if (!this.sql.hasExplicitProperties()) {
                        this.sql.setProperties(legacyString);
                    }
                    if (!this.h2.hasExplicitProperties()) {
                        this.h2.setProperties(legacyString);
                    }
                }
            }
        }

        private static String normaliseUrl(String value) {
            String processed;
            String string = processed = value == null ? "" : value.trim();
            if (processed.isEmpty()) {
                return "";
            }
            if (processed.startsWith("jdbc:")) {
                return processed;
            }
            return "jdbc:" + processed;
        }

        public static final class SqlSettings {
            private String host = "localhost";
            private int port = 5432;
            private String database = "foundryx";
            private String username = "foundryx";
            private String password = "foundryx";
            private String properties = "";
            private boolean propertiesExplicit;

            public String host() {
                return this.host;
            }

            public int port() {
                return this.port;
            }

            public String database() {
                return this.database;
            }

            public String username() {
                return this.username;
            }

            public String password() {
                return this.password;
            }

            public String properties() {
                return this.properties;
            }

            private void read(TomlTable table, TomlTable fallback) {
                this.applyFrom(fallback);
                this.applyFrom(table);
            }

            private void applyFrom(TomlTable source) {
                if (source == null) {
                    return;
                }
                this.host = ModConfig.readString(source, "host", this.host);
                this.port = Math.max(0, ModConfig.readInt(source, "port", this.port));
                this.database = ModConfig.readString(source, "database", this.database);
                this.username = ModConfig.readString(source, "username", this.username);
                this.password = ModConfig.readString(source, "password", this.password);
                Object propertyValue = source.get("properties");
                if (propertyValue instanceof String) {
                    String propertyString = (String)propertyValue;
                    this.setProperties(propertyString);
                }
            }

            void setProperties(String value) {
                this.properties = value == null ? "" : value;
                this.propertiesExplicit = true;
            }

            public boolean hasExplicitProperties() {
                return this.propertiesExplicit;
            }
        }

        public static final class H2Settings {
            private String file = "database/foundryx";
            private String properties = "AUTO_SERVER=TRUE;LOCK_TIMEOUT=60000;DB_CLOSE_DELAY=-1";
            private boolean propertiesExplicit;

            public String file() {
                return this.file;
            }

            public String properties() {
                return this.properties;
            }

            private void read(TomlTable table, TomlTable fallback) {
                this.applyFrom(fallback);
                this.applyFrom(table);
            }

            private void applyFrom(TomlTable source) {
                if (source == null) {
                    return;
                }
                String configuredFile = source.getString("file");
                if (configuredFile != null) {
                    this.file = configuredFile;
                } else {
                    String legacy = source.getString("database");
                    if (legacy != null) {
                        this.file = legacy;
                    }
                }
                Object propertyValue = source.get("properties");
                if (propertyValue instanceof String) {
                    String propertyString = (String)propertyValue;
                    this.setProperties(propertyString);
                }
            }

            public Path resolveFilePath(Path baseDirectory) {
                String configured;
                String string = configured = this.file == null ? "" : this.file.trim();
                if (configured.isEmpty()) {
                    configured = "database/foundryx";
                }
                try {
                    Path path = Path.of(configured, new String[0]);
                    if (!path.isAbsolute() && baseDirectory != null) {
                        path = baseDirectory.resolve(path);
                    }
                    return path.normalize();
                }
                catch (InvalidPathException exception) {
                    if (baseDirectory != null) {
                        return baseDirectory.resolve("database").resolve("foundryx").normalize();
                    }
                    return Path.of("database", "foundryx");
                }
            }

            void setProperties(String value) {
                this.properties = value == null ? "" : value;
                this.propertiesExplicit = true;
            }

            public boolean hasExplicitProperties() {
                return this.propertiesExplicit;
            }
        }
    }
}

