/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.data;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class BanData {
    private final UUID playerUuid;
    private final String ipAddress;
    private final String nickname;
    private final String bannedBy;
    private final String reason;
    private final Instant banDate;
    private final Instant unbanDate;

    public BanData(UUID playerUuid, String ipAddress, String nickname, String bannedBy, String reason, Instant banDate, Instant unbanDate) {
        if (playerUuid == null && (ipAddress == null || ipAddress.isBlank())) {
            throw new IllegalArgumentException("Either playerUuid or ipAddress must be provided");
        }
        this.playerUuid = playerUuid;
        this.ipAddress = ipAddress == null || ipAddress.isBlank() ? null : ipAddress;
        this.nickname = nickname;
        this.bannedBy = bannedBy;
        this.reason = reason;
        this.banDate = Objects.requireNonNull(banDate, "banDate");
        this.unbanDate = unbanDate;
    }

    public Optional<UUID> getPlayerUuid() {
        return Optional.ofNullable(this.playerUuid);
    }

    public Optional<String> getIpAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getBannedBy() {
        return this.bannedBy;
    }

    public String getReason() {
        return this.reason;
    }

    public Instant getBanDate() {
        return this.banDate;
    }

    public Optional<Instant> getUnbanDate() {
        return Optional.ofNullable(this.unbanDate);
    }

    public boolean isPermanent() {
        return this.unbanDate == null;
    }

    public boolean isPlayerBan() {
        return this.playerUuid != null;
    }

    public boolean isIpBan() {
        return this.ipAddress != null;
    }
}

